/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sk extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "moskovsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "moskovsk\u00fd letn\u00fd \u010das",
               "",
               "moskovsk\u00fd \u010das",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "pakistansk\u00fd letn\u00fd \u010das",
               "",
               "pakistansk\u00fd \u010das",
               "",
            };
        final String[] Magadan = new String[] {
               "magadansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "magadansk\u00fd letn\u00fd \u010das",
               "",
               "magadansk\u00fd \u010das",
               "",
            };
        final String[] Europe_Central = new String[] {
               "stredoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "SE\u010c",
               "stredoeur\u00f3psky letn\u00fd \u010das",
               "SEL\u010c",
               "stredoeur\u00f3psky \u010das",
               "SE\u010c",
            };
        final String[] Acre = new String[] {
               "acrejsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "acrejsk\u00fd letn\u00fd \u010das",
               "",
               "acrejsk\u00fd \u010das",
               "",
            };
        final String[] America_Eastern = new String[] {
               "severoamerick\u00fd v\u00fdchodn\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "severoamerick\u00fd v\u00fdchodn\u00fd letn\u00fd \u010das",
               "",
               "severoamerick\u00fd v\u00fdchodn\u00fd \u010das",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "\u0161tandardn\u00fd \u010das ostrova lorda Howa",
               "",
               "letn\u00fd \u010das ostrova lorda Howa",
               "",
               "\u010das ostrova lorda Howa",
               "",
            };
        final String[] New_Zealand = new String[] {
               "novoz\u00e9landsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "novoz\u00e9landsk\u00fd letn\u00fd \u010das",
               "",
               "novoz\u00e9landsk\u00fd \u010das",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "indickooce\u00e1nsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "jakutsk\u00fd letn\u00fd \u010das",
               "",
               "jakutsk\u00fd \u010das",
               "",
            };
        final String[] East_Timor = new String[] {
               "v\u00fdchodotimorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "kosrajsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "v\u00fdchodoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "",
               "v\u00fdchodoeur\u00f3psky letn\u00fd \u010das",
               "",
               "v\u00fdchodoeur\u00f3psky \u010das",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "z\u00e1padoargent\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padoargent\u00ednsky letn\u00fd \u010das",
               "",
               "z\u00e1padoargent\u00ednsky \u010das",
               "",
            };
        final String[] Ponape = new String[] {
               "ponapsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "bol\u00edvijsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "pierre-miquelonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "pierre-miquelonsk\u00fd letn\u00fd \u010das",
               "",
               "pierre-miquelonsk\u00fd \u010das",
               "",
            };
        final String[] Indochina = new String[] {
               "indo\u010d\u00ednsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekaterinbursk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "jekaterinbursk\u00fd letn\u00fd \u010das",
               "",
               "jekaterinbursk\u00fd \u010das",
               "",
            };
        final String[] Maldives = new String[] {
               "maldivsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahitsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "\u010das ostrovov Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "juhoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "\u010das stanice \u0160\u00f3wa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "\u010das Rovn\u00edkov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzbeck\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "uzbeck\u00fd letn\u00fd \u010das",
               "",
               "uzbeck\u00fd \u010das",
               "",
            };
        final String[] Mongolia = new String[] {
               "ulanb\u00e1tarsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "ulanb\u00e1tarsk\u00fd letn\u00fd \u010das",
               "",
               "ulanb\u00e1tarsk\u00fd \u010das",
               "",
            };
        final String[] America_Central = new String[] {
               "severoamerick\u00fd centr\u00e1lny \u0161tandardn\u00fd \u010das",
               "",
               "severoamerick\u00fd centr\u00e1lny letn\u00fd \u010das",
               "",
               "severoamerick\u00fd centr\u00e1lny \u010das",
               "",
            };
        final String[] Niue = new String[] {
               "niuejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "\u010das ostrova Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "falklandsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "falklandsk\u00fd letn\u00fd \u010das",
               "",
               "falklandsk\u00fd \u010das",
               "",
            };
        final String[] Bhutan = new String[] {
               "bhut\u00e1nsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Apia = new String[] {
               "apijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "apijsk\u00fd letn\u00fd \u010das",
               "",
               "apijsk\u00fd \u010das",
               "",
            };
        final String[] Nauru = new String[] {
               "naurusk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "z\u00e1padokazachstansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "\u010das Viano\u010dn\u00e9ho ostrova",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "r\u00e9unionsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "\u010das Kokosov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "chathamsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "chathamsk\u00fd letn\u00fd \u010das",
               "",
               "chathamsk\u00fd \u010das",
               "",
            };
        final String[] Vostok = new String[] {
               "\u010das stanice Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argent\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "argent\u00ednsky letn\u00fd \u010das",
               "",
               "argent\u00ednsky \u010das",
               "",
            };
        final String[] Gambier = new String[] {
               "gambiersk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "galap\u00e1gsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u010das F\u00e9nixov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kapverdsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "kapverdsk\u00fd letn\u00fd \u010das",
               "",
               "kapverdsk\u00fd \u010das",
               "",
            };
        final String[] Norfolk = new String[] {
               "norfolsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "samojsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "samojsk\u00fd letn\u00fd \u010das",
               "",
               "samojsk\u00fd \u010das",
               "",
            };
        final String[] Davis = new String[] {
               "\u010das Davisovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "kub\u00e1nsky \u0161tandardn\u00fd \u010das",
               "",
               "kub\u00e1nsky letn\u00fd \u010das",
               "",
               "kub\u00e1nsky \u010das",
               "",
            };
        final String[] GMT = new String[] {
               "greenwichsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "filip\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "filip\u00ednsky letn\u00fd \u010das",
               "",
               "filip\u00ednsky \u010das",
               "",
            };
        final String[] French_Southern = new String[] {
               "\u010das Franc\u00fazskych ju\u017en\u00fdch a antarktick\u00fdch \u00fazem\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "novokaled\u00f3nsky \u0161tandardn\u00fd \u010das",
               "",
               "novokaled\u00f3nsky letn\u00fd \u010das",
               "",
               "novokaled\u00f3nsky \u010das",
               "",
            };
        final String[] Brunei = new String[] {
               "brunejsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "ir\u00e1nsky \u0161tandardn\u00fd \u010das",
               "",
               "ir\u00e1nsky letn\u00fd \u010das",
               "",
               "ir\u00e1nsky \u010das",
               "",
            };
        final String[] Tajikistan = new String[] {
               "tad\u017eick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ton\u017esk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "ton\u017esk\u00fd letn\u00fd \u010das",
               "",
               "ton\u017esk\u00fd \u010das",
               "",
            };
        final String[] Bangladesh = new String[] {
               "banglad\u00e9\u0161sky \u0161tandardn\u00fd \u010das",
               "",
               "banglad\u00e9\u0161sky letn\u00fd \u010das",
               "",
               "banglad\u00e9\u0161sky \u010das",
               "",
            };
        final String[] Peru = new String[] {
               "peru\u00e1nsky \u0161tandardn\u00fd \u010das",
               "",
               "peru\u00e1nsky letn\u00fd \u010das",
               "",
               "peru\u00e1nsky \u010das",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "v\u00fdchodogr\u00f3nsky \u0161tandardn\u00fd \u010das",
               "",
               "v\u00fdchodogr\u00f3nsky letn\u00fd \u010das",
               "",
               "v\u00fdchodogr\u00f3nsky \u010das",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "v\u00fdchodoindon\u00e9zsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgizsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "kolumbijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "kolumbijsk\u00fd letn\u00fd \u010das",
               "",
               "kolumbijsk\u00fd \u010das",
               "",
            };
        final String[] French_Guiana = new String[] {
               "franc\u00fazskoguyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "v\u00fdchodoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "",
               "v\u00fdchodoaustr\u00e1lsky letn\u00fd \u010das",
               "",
               "v\u00fdchodoaustr\u00e1lsky \u010das",
               "",
            };
        final String[] Chile = new String[] {
               "\u010dilsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "\u010dilsk\u00fd letn\u00fd \u010das",
               "",
               "\u010dilsk\u00fd \u010das",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u010das Gilbertov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "irkutsk\u00fd letn\u00fd \u010das",
               "",
               "irkutsk\u00fd \u010das",
               "",
            };
        final String[] Georgia = new String[] {
               "gruz\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "gruz\u00ednsky letn\u00fd \u010das",
               "",
               "gruz\u00ednsky \u010das",
               "",
            };
        final String[] Choibalsan = new String[] {
               "\u010dojbalsansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "\u010dojbalsansk\u00fd letn\u00fd \u010das",
               "",
               "\u010dojbalsansk\u00fd \u010das",
               "",
            };
        final String[] China = new String[] {
               "\u010d\u00ednsky \u0161tandardn\u00fd \u010das",
               "",
               "\u010d\u00ednsky letn\u00fd \u010das",
               "",
               "\u010d\u00ednsky \u010das",
               "",
            };
        final String[] Armenia = new String[] {
               "arm\u00e9nsky \u0161tandardn\u00fd \u010das",
               "",
               "arm\u00e9nsky letn\u00fd \u010das",
               "",
               "arm\u00e9nsky \u010das",
               "",
            };
        final String[] Africa_Central = new String[] {
               "stredoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "japonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "japonsk\u00fd letn\u00fd \u010das",
               "",
               "japonsk\u00fd \u010das",
               "",
            };
        final String[] Taipei = new String[] {
               "tchajpejsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "tchajpejsk\u00fd letn\u00fd \u010das",
               "",
               "tchajpejsk\u00fd \u010das",
               "",
            };
        final String[] Hovd = new String[] {
               "chovdsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "chovdsk\u00fd letn\u00fd \u010das",
               "",
               "chovdsk\u00fd \u010das",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "stredoz\u00e1padn\u00fd austr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "",
               "stredoz\u00e1padn\u00fd austr\u00e1lsky letn\u00fd \u010das",
               "",
               "stredoz\u00e1padn\u00fd austr\u00e1lsky \u010das",
               "",
            };
        final String[] Sakhalin = new String[] {
               "sachalinsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "sachalinsk\u00fd letn\u00fd \u010das",
               "",
               "sachalinsk\u00fd \u010das",
               "",
            };
        final String[] Paraguay = new String[] {
               "paraguajsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "paraguajsk\u00fd letn\u00fd \u010das",
               "",
               "paraguajsk\u00fd \u010das",
               "",
            };
        final String[] Casey = new String[] {
               "\u010das Caseyho stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajzijsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "maur\u00edcijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "maur\u00edcijsk\u00fd letn\u00fd \u010das",
               "",
               "maur\u00edcijsk\u00fd \u010das",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "v\u00fdchodoafrick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "\u010das \u0160alam\u00fanov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "\u010das Marshallov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "newfoundlandsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "newfoundlandsk\u00fd letn\u00fd \u010das",
               "",
               "newfoundlandsk\u00fd \u010das",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afgansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "hongkonsk\u00fd letn\u00fd \u010das",
               "",
               "hongkonsk\u00fd \u010das",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlantick\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "atlantick\u00fd letn\u00fd \u010das",
               "",
               "atlantick\u00fd \u010das",
               "",
            };
        final String[] Israel = new String[] {
               "izraelsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "izraelsk\u00fd letn\u00fd \u010das",
               "",
               "izraelsk\u00fd \u010das",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "stredoindon\u00e9zsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "omsk\u00fd letn\u00fd \u010das",
               "",
               "omsk\u00fd \u010das",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychelsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguajsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "uruguajsk\u00fd letn\u00fd \u010das",
               "",
               "uruguajsk\u00fd \u010das",
               "",
            };
        final String[] Nepal = new String[] {
               "nep\u00e1lsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "chuuksk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "vanuatsk\u00fd letn\u00fd \u010das",
               "",
               "vanuatsk\u00fd \u010das",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "novosibirsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "novosibirsk\u00fd letn\u00fd \u010das",
               "",
               "novosibirsk\u00fd \u010das",
               "",
            };
        final String[] Singapore = new String[] {
               "singapursk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "azorsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "azorsk\u00fd letn\u00fd \u010das",
               "",
               "azorsk\u00fd \u010das",
               "",
            };
        final String[] Suriname = new String[] {
               "surinamsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "krasnojarsk\u00fd letn\u00fd \u010das",
               "",
               "krasnojarsk\u00fd \u010das",
               "",
            };
        final String[] Myanmar = new String[] {
               "mjanmarsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "amazonsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "amazonsk\u00fd letn\u00fd \u010das",
               "",
               "amazonsk\u00fd \u010das",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "v\u00fdchodokazachstansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "fid\u017eijsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "fid\u017eijsk\u00fd letn\u00fd \u010das",
               "",
               "fid\u017eijsk\u00fd \u010das",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kam\u010datsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "Petropavlovsk-Kam\u010datskijsk\u00fd letn\u00fd \u010das",
               "",
               "Petropavlovsk-Kam\u010datsk\u00fd \u010das",
               "",
            };
        final String[] Tuvalu = new String[] {
               "tuvalsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "\u010das ostrova Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "havajsko-aleutsk\u00fd letn\u00fd \u010das",
               "",
               "havajsko-aleutsk\u00fd \u010das",
               "",
            };
        final String[] Australia_Central = new String[] {
               "stredoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "",
               "stredoaustr\u00e1lsky letn\u00fd \u010das",
               "",
               "stredoaustr\u00e1lsky \u010das",
               "",
            };
        final String[] America_Pacific = new String[] {
               "severoamerick\u00fd tichomorsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "severoamerick\u00fd tichomorsk\u00fd letn\u00fd \u010das",
               "",
               "severoamerick\u00fd tichomorsk\u00fd \u010das",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "turkm\u00e9nsky \u0161tandardn\u00fd \u010das",
               "",
               "turkm\u00e9nsky letn\u00fd \u010das",
               "",
               "turkm\u00e9nsky \u010das",
               "",
            };
        final String[] Europe_Western = new String[] {
               "z\u00e1padoeur\u00f3psky \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padoeur\u00f3psky letn\u00fd \u010das",
               "",
               "z\u00e1padoeur\u00f3psky \u010das",
               "",
            };
        final String[] Guyana = new String[] {
               "guyansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "\u010das Pitcairnov\u00fdch ostrovov",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "\u010das Rotherovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajd\u017eansk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "azerbajd\u017eansk\u00fd letn\u00fd \u010das",
               "",
               "azerbajd\u017eansk\u00fd \u010das",
               "",
            };
        final String[] Mawson = new String[] {
               "\u010das Mawsonovej stanice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexick\u00fd tichomorsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "mexick\u00fd tichomorsk\u00fd letn\u00fd \u010das",
               "",
               "mexick\u00fd tichomorsk\u00fd \u010das",
               "",
            };
        final String[] Africa_Western = new String[] {
               "z\u00e1padoafrick\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padoafrick\u00fd letn\u00fd \u010das",
               "",
               "z\u00e1padoafrick\u00fd \u010das",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u010das Ju\u017enej Georgie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "severoz\u00e1padn\u00fd mexick\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "severoz\u00e1padn\u00fd mexick\u00fd letn\u00fd \u010das",
               "",
               "severoz\u00e1padn\u00fd mexick\u00fd \u010das",
               "",
            };
        final String[] Easter = new String[] {
               "\u0161tandardn\u00fd \u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "",
               "letn\u00fd \u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "",
               "\u010das Ve\u013ekono\u010dn\u00e9ho ostrova",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "\u010das stanice Dumonta d\u2019Urvillea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "z\u00e1padogr\u00f3nsky \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padogr\u00f3nsky letn\u00fd \u010das",
               "",
               "z\u00e1padogr\u00f3nsky \u010das",
               "",
            };
        final String[] Ecuador = new String[] {
               "ekv\u00e1dorsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "\u0161tandardn\u00fd \u010das Perzsk\u00e9ho z\u00e1livu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "k\u00f3rejsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "k\u00f3rejsk\u00fd letn\u00fd \u010das",
               "",
               "k\u00f3rejsk\u00fd \u010das",
               "",
            };
        final String[] Australia_Western = new String[] {
               "z\u00e1padoaustr\u00e1lsky \u0161tandardn\u00fd \u010das",
               "",
               "z\u00e1padoaustr\u00e1lsky letn\u00fd \u010das",
               "",
               "z\u00e1padoaustr\u00e1lsky \u010das",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "z\u00e1padoindon\u00e9zsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "severoamerick\u00fd horsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "severoamerick\u00fd horsk\u00fd letn\u00fd \u010das",
               "",
               "severoamerick\u00fd horsk\u00fd \u010das",
               "",
            };
        final String[] Marquesas = new String[] {
               "mark\u00e9zsky \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arabsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "arabsk\u00fd letn\u00fd \u010das",
               "",
               "arabsk\u00fd \u010das",
               "",
            };
        final String[] Alaska = new String[] {
               "alja\u0161sk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "alja\u0161sk\u00fd letn\u00fd \u010das",
               "",
               "alja\u0161sk\u00fd \u010das",
               "",
            };
        final String[] Vladivostok = new String[] {
               "vladivostock\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "vladivostock\u00fd letn\u00fd \u010das",
               "",
               "vladivostock\u00fd \u010das",
               "",
            };
        final String[] Chamorro = new String[] {
               "chamorrsk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelausk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u010das Papuy-Novej Guiney",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "\u0161tandardn\u00fd \u010das s\u00faostrovia Fernando de Noronha",
               "",
               "letn\u00fd \u010das s\u00faostrovia Fernando de Noronha",
               "",
               "\u010das s\u00faostrovia Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "braz\u00edlsky \u0161tandardn\u00fd \u010das",
               "",
               "braz\u00edlsky letn\u00fd \u010das",
               "",
               "braz\u00edlsky \u010das",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyrsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "Anadyrsk\u00fd letn\u00fd \u010das",
               "",
               "Anadyrsk\u00fd \u010das",
               "",
            };
        final String[] Samara = new String[] {
               "Samarsk\u00fd \u0161tandardn\u00fd \u010das",
               "",
               "Samarsk\u00fd letn\u00fd \u010das",
               "",
               "Samarsk\u00fd \u010das",
               "",
            };
        final String[] Pyongyang = new String[] {
               "pchjongjansk\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indick\u00fd \u010das",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "\u0161tandardn\u00fd \u010das Cookov\u00fdch ostrovov",
               "",
               "letn\u00fd \u010das Cookov\u00fdch ostrovov",
               "",
               "\u010das Cookov\u00fdch ostrovov",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.Asia/Katmandu", "K\u00e1thmandu" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "\u013dub\u013eana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Mark\u00e9zy" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "",
                    "britsk\u00fd letn\u00fd \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Severn\u00e1 Dakota" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Europe/Gibraltar", "Gibralt\u00e1r" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "America/Eirunepe", Acre },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Lond\u00fdn" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "HST",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "\u010cojbalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Sv\u00e4t\u00e1 Lucia" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzneck" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Severn\u00e1 Dakota" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Ju\u017en\u00e1 Georgia" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom P\u00e9nh" },
            { "timezone.excity.Europe/Rome", "R\u00edm" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Kar\u00e1\u010di" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "El-Aai\u00fan" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Severn\u00e1 Dakota" },
            { "timezone.excity.Asia/Atyrau", "Atyrau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "New York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "nezn\u00e1me mesto" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "U\u017ehorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.Asia/Baku", "Baku" },
            { "timezone.excity.Asia/Hovd", "Chovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc-Sablon" },
            { "timezone.excity.Africa/Algiers", "Al\u017e\u00edr" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Chart\u00fam" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galap\u00e1gy" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucuman" },
            { "timezone.excity.America/Rio_Branco", "Rio Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "U\u013ejanovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "",
                    "\u00edrsky \u0161tandardn\u00fd \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Sv\u00e4t\u00e1 Helena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxembursko" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrajn" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "timezone.excity.Europe/Isle_of_Man", "Ostrov Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Par\u00ed\u017e" },
            { "timezone.excity.Europe/Zagreb", "Z\u00e1hreb" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budape\u0161\u0165" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161o" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Tchaj-pej" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "greenwichsk\u00fd \u010das",
                    "",
                    "britsk\u00fd letn\u00fd \u010das",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dh\u00e1ka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanb\u00e1tar" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolymsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kapverdy" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "MST", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Atlantic/Azores", "Azory" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientian" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Viano\u010dn\u00fd ostrov" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Canc\u00fan" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "koordinovan\u00fd svetov\u00fd \u010das",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161i\u0148ov" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Mar\u00edno" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "\u0160anghaj" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salv\u00e1dor" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Ve\u013ekono\u010dn\u00fd ostrov" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1rske ostrovy" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "K\u00e1hira" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "Sv\u00e4t\u00fd Tom\u00e1\u0161" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatik\u00e1n" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Bejr\u00fat" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Sv. Vincent" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kergueleny" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pchjongjang" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161\u0165" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "At\u00e9ny" },
            { "Africa/Djibouti", Africa_Eastern },
            { "EST", America_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Koda\u0148" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Rij\u00e1d" },
            { "Antarctica/Casey", Casey },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Us\u0165-Nera" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Ho\u010diminovo Mesto" },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makassar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrach\u00e1n" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belehrad" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Kalkata" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "M\u00e9xico" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Z\u00e1poro\u017eie" },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10",
                new String[] {
                    "havajsko-aleutsk\u00fd \u0161tandardn\u00fd \u010das",
                    "HST",
                    "havajsko-aleutsk\u00fd letn\u00fd \u010das",
                    "HDT",
                    "havajsko-aleutsk\u00fd \u010das",
                    "HST",
                }
            },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Maur\u00edcius" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariehamn" },
            { "timezone.excity.America/St_Barthelemy", "Sv\u00e4t\u00fd Bartolomej" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Ura\u013esk" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Soul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Sv. Tom\u00e1\u0161" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "America/Rio_Branco", Acre },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.Asia/Macau", "Macao" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "timezone.excity.Asia/Samarkand", "Samarkand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Viede\u0148" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Kajmanie ostrovy" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nik\u00f3zia" },
            { "timezone.excity.Europe/Kiev", "Kyjev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Atlantic/Faeroe", "Faersk\u00e9 ostrovy" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Ku\u010ding" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "timezone.excity.America/Merida", "M\u00e9rida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "A\u0161chabad" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "\u0160\u00f3wa" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "R\u00e9union" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "K\u00e1bul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Kokosov\u00e9 ostrovy" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "\u0160tokholm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Maldivy" },
        };
        return data;
    }
}
