/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.navTree;

import de.bmwrudel.wds.navTree.WDSNavigationTreeNode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class WDSNavigationTree {
    private static Logger _logger = LogManager.getLogger();
    private String _xmlFile = null;

    public WDSNavigationTree(String xmlFile) {
        this._xmlFile = xmlFile;
    }

    public DefaultTreeModel getTreeModel() throws JDOMException, IOException {
        _logger.debug("Loading navigation tree model");
        Element treeRoot = this.getTreeRoot();
        DefaultTreeModel treeModel = null;
        if (treeRoot != null) {
            treeModel = new DefaultTreeModel(this.traverseParialTree(this.getTreeRoot()));
        }
        _logger.debug("Loading navigation tree model done");
        return treeModel;
    }

    private Element getTreeRoot() throws JDOMException, IOException {
        _logger.debug("Getting navigation tree model root");
        SAXBuilder builder = new SAXBuilder();
        Element treeRoot = null;
        Document doc = builder.build((Reader)new StringReader(this._xmlFile));
        Element rootElement = doc.getRootElement();
        if (rootElement.removeChild("imageList")) {
            _logger.debug("Child imageList removed from tree");
            treeRoot = rootElement.getChild("root");
        }
        return treeRoot;
    }

    private WDSNavigationTreeNode traverseParialTree(Element domNode) {
        WDSNavigationTreeNode treeNode = null;
        treeNode = domNode.getName().equals("leaf") ? new WDSNavigationTreeNode(domNode.getAttributeValue("name"), domNode.getAttributeValue("link"), Integer.valueOf(domNode.getAttributeValue("image"))) : new WDSNavigationTreeNode((Object)domNode.getAttributeValue("name"), domNode.getAttributeValue("id"));
        List nodeList = domNode.getChildren();
        for (Element child : nodeList) {
            treeNode.add(this.traverseParialTree(child));
        }
        return treeNode;
    }
}

