/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.main;

import de.bmwrudel.wds.dialogs.WDSSelectModelDialog;
import de.bmwrudel.wds.fs.Doublet;
import de.bmwrudel.wds.fs.H2_FS;
import de.bmwrudel.wds.fs.WdsFS;
import de.bmwrudel.wds.gui.JStatusBar;
import de.bmwrudel.wds.gui.JTabbedPaneCloseButton;
import de.bmwrudel.wds.gui.WDSJTree;
import de.bmwrudel.wds.listeners.BookmarkActionListener;
import de.bmwrudel.wds.listeners.MainMenuActionListener;
import de.bmwrudel.wds.listeners.WDSSearchActionListener;
import de.bmwrudel.wds.localization.Messages;
import de.bmwrudel.wds.navTree.WDSNavigationTree;
import de.bmwrudel.wds.navTree.WDSNavigationTreeNode;
import de.bmwrudel.wds.protocolHandler.WDS_ProtocolHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.DefaultTreeModel;
import org.apache.batik.swing.JSVGScrollPane;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLProtocolHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.JDOMException;

public class Main {
    private static Logger _logger = LogManager.getLogger();

    public static void main(String[] args) {
        _logger.info("WDS started");
        try {
            _logger.debug("Available look & feels:");
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                _logger.debug(" --- " + info.getName());
            }
            _logger.debug("End available look & feels");
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equalsIgnoreCase(info.getName())) continue;
                _logger.info("Trying to set Nimbus look & feel");
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception e) {
            try {
                _logger.info("Nimbus not available, setting cross platform look & feel");
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        WdsFS fs = new WdsFS();
        WDSSelectModelDialog dialog = new WDSSelectModelDialog();
        String showDialog = dialog.showDialog();
        if (showDialog == null) {
            _logger.info("No model selected --> exiting");
            WdsFS.shutdown();
            System.exit(0);
        }
        _logger.info("Choosen model: " + showDialog);
        fs.setModel(showDialog);
        String navigationXML = fs.getNavigationXML();
        if (navigationXML == null) {
            _logger.error("Could not load navigation xml, exiting");
            WdsFS.shutdown();
            System.exit(-1);
        }
        WDSNavigationTree tree = new WDSNavigationTree(navigationXML);
        DefaultTreeModel treeModel = null;
        WDSJTree navTree = null;
        JFrame frame = new JFrame();
        frame.setIconImage(WdsFS.getLogo());
        frame.setPreferredSize(new Dimension(1024, 768));
        frame.setSize(frame.getPreferredSize());
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new BorderLayout());
        try {
            treeModel = tree.getTreeModel();
            navTree = new WDSJTree(treeModel);
            frame.setTitle(Messages.getString("Frame.title") + " - " + ((WDSNavigationTreeNode)treeModel.getRoot()).getName());
        }
        catch (IOException | JDOMException ex) {
            _logger.error("Error building navigation tree", ex);
        }
        ParsedURL.registerHandler((ParsedURLProtocolHandler)new WDS_ProtocolHandler(navTree));
        JStatusBar statusBar = new JStatusBar();
        JMenuBar menuBar = new JMenuBar();
        MainMenuActionListener mmal = new MainMenuActionListener();
        JMenu file = new JMenu(Messages.getString("MainMenu.file"));
        JMenuItem menuItemExit = new JMenuItem(Messages.getString("MainMenu.exit"));
        menuItemExit.setActionCommand("exit");
        menuItemExit.addActionListener(mmal);
        file.add(menuItemExit);
        JMenu bookmarks = new JMenu(Messages.getString("Bookmarks.title"));
        bookmarks.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JMenu source = (JMenu)e.getSource();
                ((JMenu)e.getSource()).removeAll();
                List<Doublet<Integer, String>> bookmarkList = H2_FS.getInstance().getBookmarkList();
                for (Doublet<Integer, String> bookmark : bookmarkList) {
                    JMenuItem item = new JMenuItem(bookmark.getSecond());
                    item.setIcon(WdsFS.getIconForId(bookmark.getFirst()));
                    item.setActionCommand(bookmark.getSecond());
                    item.addActionListener(new BookmarkActionListener());
                    source.add(item);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        menuBar.add(file);
        menuBar.add(bookmarks);
        frame.setJMenuBar(menuBar);
        JPanel northPanel = new JPanel(new FlowLayout(0));
        northPanel.setBackground(new Color(74, 74, 74));
        JLabel label = new JLabel(Messages.getString("Frame.Search.label"));
        label.setFont(WdsFS.globalProBold().deriveFont(14.0f));
        label.setForeground(WdsFS.getCyanColor());
        northPanel.add(label);
        WDSSearchActionListener wdsSearchActionListener = new WDSSearchActionListener();
        JTextField searchText = new JTextField(20);
        searchText.setFont(WdsFS.globalProRegular().deriveFont(14.0f));
        searchText.setBackground(WdsFS.getCyanColor());
        searchText.addActionListener(wdsSearchActionListener);
        northPanel.add(searchText);
        JButton btnSearch = new JButton(Messages.getString("Frame.Search.buttonText"));
        btnSearch.setFont(WdsFS.globalProBold().deriveFont(14.0f));
        btnSearch.setBackground(WdsFS.getGreyColor());
        btnSearch.setForeground(WdsFS.getCyanColor());
        btnSearch.addActionListener(wdsSearchActionListener);
        northPanel.add(btnSearch);
        JScrollPane navScrollPane = new JScrollPane(navTree);
        navScrollPane.setViewportView(navTree);
        JSplitPane split = new JSplitPane(1, true);
        split.setContinuousLayout(true);
        split.setOneTouchExpandable(true);
        split.setLeftComponent(navScrollPane);
        final JTabbedPaneCloseButton tabbed = new JTabbedPaneCloseButton();
        tabbed.setTabPlacement(1);
        tabbed.setTabLayoutPolicy(0);
        tabbed.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u0017') {
                    tabbed.remove(tabbed.getSelectedIndex());
                }
                int i = 10;
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        tabbed.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu pop = new JPopupMenu();
                    pop.add(new AbstractAction(Messages.getString("TabbedPane.menu.closeThis")){
                        private static final long serialVersionUID = 4035185457815728676L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JComponent source = (JComponent)e.getSource();
                            JTabbedPane tabbedPane = (JTabbedPane)((JPopupMenu)source.getParent()).getInvoker();
                            Component selectedComponent = tabbedPane.getSelectedComponent();
                            if (selectedComponent instanceof JSVGScrollPane || selectedComponent instanceof JScrollPane) {
                                tabbed.remove(selectedComponent);
                            }
                        }
                    });
                    pop.add(new AbstractAction(Messages.getString("TabbedPane.menu.closeOthers")){
                        private static final long serialVersionUID = -8126005506415018823L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JComponent source = (JComponent)e.getSource();
                            JTabbedPane tabbedPane = (JTabbedPane)((JPopupMenu)source.getParent()).getInvoker();
                            Component selectedComponent = tabbedPane.getSelectedComponent();
                            for (Component comp : tabbedPane.getComponents()) {
                                if (!(comp instanceof JSVGScrollPane) && !(comp instanceof JScrollPane) || comp == selectedComponent) continue;
                                tabbed.remove(comp);
                            }
                        }
                    });
                    pop.add(new AbstractAction(Messages.getString("TabbedPane.menu.closeAll")){
                        private static final long serialVersionUID = -7387443438633027769L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JComponent source = (JComponent)e.getSource();
                            JTabbedPane tabbedPane = (JTabbedPane)((JPopupMenu)source.getParent()).getInvoker();
                            tabbedPane.removeAll();
                        }
                    });
                    pop.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        split.setRightComponent(tabbed);
        frame.add("North", northPanel);
        frame.add("Center", split);
        frame.add("South", statusBar);
        frame.pack();
        frame.setVisible(true);
    }
}

