/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.localization;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Messages {
    private static final String BUNDLE_NAME = "de.bmwrudel.wds.localization.messages";
    private static ResourceBundle _bundle = ResourceBundle.getBundle("de.bmwrudel.wds.localization.messages");
    private static Logger _logger = LogManager.getLogger();

    private Messages() {
    }

    public static String getString(String key) {
        try {
            return _bundle.getString(key);
        }
        catch (MissingResourceException e) {
            _logger.error("No string for key " + key);
            return '!' + key + '!';
        }
    }

    public static String getLanguage() {
        String lang = null;
        _logger.info("Requested country: " + Locale.getDefault().getCountry().toLowerCase());
        switch (Locale.getDefault().getCountry().toLowerCase()) {
            case "de": {
                lang = "de";
                break;
            }
            case "en": {
                lang = "en";
                break;
            }
            case "us": {
                lang = "us";
                break;
            }
            default: {
                lang = "en";
            }
        }
        _logger.info("Returned country: " + lang);
        return lang;
    }
}

