/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.listeners;

import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WDSSVGMouseWheelListener
implements MouseWheelListener {
    private static final Logger _logger = LogManager.getLogger();
    private double _scaleX = 1.0;
    private double _scaleY = 1.0;
    private double _stepSize = 0.1;
    private JSVGCanvas canvas;
    private Point2D p2;

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.canvas = null;
        Point p1 = e.getPoint();
        this.p2 = null;
        if (e.getSource() instanceof JSVGCanvas) {
            this.canvas = (JSVGCanvas)e.getSource();
        }
        AffineTransform at = this.canvas.getRenderingTransform();
        try {
            this.p2 = at.inverseTransform(p1, null);
        }
        catch (NoninvertibleTransformException e1) {
            _logger.error(e1);
        }
        this._scaleX -= this._stepSize * (double)e.getWheelRotation();
        this._scaleY -= this._stepSize * (double)e.getWheelRotation();
        this._scaleX = Math.max(this._scaleX, this._stepSize);
        this._scaleY = Math.max(this._scaleY, this._stepSize);
        at.setToIdentity();
        at.translate(((Point2D)p1).getX(), ((Point2D)p1).getY());
        at.scale(this._scaleX, this._scaleY);
        at.translate(-this.p2.getX(), -this.p2.getY());
        this.canvas.setRenderingTransform(at, true);
    }
}

