/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.gui;

import de.bmwrudel.wds.cellRenderer.WDSCellRenderer;
import de.bmwrudel.wds.fs.WdsFS;
import de.bmwrudel.wds.interfaces.SVGLinkClickEventListener;
import de.bmwrudel.wds.listeners.WDSJTreeMouseListener;
import de.bmwrudel.wds.navTree.WDSNavigationTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WDSJTree
extends JTree
implements SVGLinkClickEventListener {
    private static final long serialVersionUID = -639433747451954412L;
    private static final Logger _logger = LogManager.getLogger();

    public WDSJTree(DefaultTreeModel model) {
        this.setBackground(WdsFS.getCyanColor());
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new WDSCellRenderer());
        this.addMouseListener(new WDSJTreeMouseListener());
        this.setModel(model);
    }

    @Override
    public void linkClicked(String id) {
        WDSNavigationTreeNode searchNode = this.searchNode(id, this.getModel());
        TreePath treePath = new TreePath(searchNode.getPath());
        if (treePath != null) {
            this.expandPath(treePath);
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(this.getSelectionPath());
        }
    }

    private WDSNavigationTreeNode searchNode(String filter, TreeModel model) {
        WDSNavigationTreeNode node = null;
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)model.getRoot()).breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            node = (WDSNavigationTreeNode)e.nextElement();
            if (!filter.equals(node.getId())) continue;
            return node;
        }
        return null;
    }

    public List<TreePath> findNodes(String searchString) {
        WDSNavigationTreeNode root = (WDSNavigationTreeNode)this.getModel().getRoot();
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        this.getChildrenWithFilter(root, list, searchString);
        return list;
    }

    private void getChildrenWithFilter(WDSNavigationTreeNode node, List<TreePath> list, String filter) {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            WDSNavigationTreeNode object = (WDSNavigationTreeNode)children.nextElement();
            if (object.getName().toUpperCase().contains(filter.toUpperCase()) && object.isLeaf()) {
                _logger.debug(new TreePath(object.getPath()).toString());
                list.add(new TreePath(object.getPath()));
            }
            this.getChildrenWithFilter(object, list, filter);
        }
    }

    public void collapseAll() {
        this.setNodeExpandedState(this, (DefaultMutableTreeNode)this.getModel().getRoot(), false);
    }

    private void setNodeExpandedState(JTree tree, TreeNode treeNode2, boolean expanded) {
        ArrayList<? extends TreeNode> list = Collections.list(treeNode2.children());
        for (TreeNode treeNode : list) {
            this.setNodeExpandedState(tree, treeNode, expanded);
        }
        if (!expanded && ((DefaultMutableTreeNode)treeNode2).isRoot()) {
            return;
        }
        TreePath path = new TreePath(((DefaultMutableTreeNode)treeNode2).getPath());
        if (expanded) {
            tree.expandPath(path);
        } else {
            tree.collapsePath(path);
        }
    }
}

