/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.fs;

import de.bmwrudel.wds.fs.H2_FS;
import de.bmwrudel.wds.fs.Triplet;
import de.bmwrudel.wds.localization.Messages;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WdsFS {
    private static Logger _logger = LogManager.getLogger();
    private static String _model;
    private static final String _root;
    private static final String _htmlLocation;
    private static final String _svgLocation;
    private static final String _imagesLocation = "res/images/";
    private static final String _modelImagesLocation = "res/images/models/";
    private static final String _iconLocation = "res/images/icons/";
    private static final String _cssLocation;
    private static final String _ziImageLocation;
    private static ImageIcon _bmwIcon;
    private static BufferedImage _splashImage;
    private static HashMap<Integer, Icon> _iconMap;
    private static HashMap<String, Integer> _IdMap;
    private static List<Triplet<String, String, Icon>> _modelMap;
    private static final Color _cyanColor;
    private static final Color _greyColor;
    private static Font _webProBold;
    private static Font _globalProBold;
    private static Font _globalProLight;
    private static Font _globalProRegular;

    public WdsFS() {
        this.buildIconList();
        this.buildModelList();
        _bmwIcon = new ImageIcon("res/images/bmwlogo.gif");
        try {
            _logger.debug("Trying to load BMW Fonts");
            _globalProBold = Font.createFont(0, new File("res/fonts/bmwtypeglobalpro-bold.ttf"));
            _globalProLight = Font.createFont(0, new File("res/fonts/bmwtypeglobalpro-light.ttf"));
            _globalProRegular = Font.createFont(0, new File("res/fonts/bmwtypeglobalpro-regular.ttf"));
            _webProBold = Font.createFont(0, new File("res/fonts/bmwtypewebbo_all.ttf"));
            _logger.debug("Loading BMW Fonts done");
        }
        catch (FontFormatException | IOException ex) {
            _logger.error("Error while loading BMW Fonts", (Throwable)ex);
        }
        try {
            _splashImage = ImageIO.read(new File("res/images/wds_logo.jpg"));
        }
        catch (IOException ex) {
            _logger.error("Error by loading splash picture", (Throwable)ex);
        }
        H2_FS.getInstance().startup_h2();
    }

    public void setModel(String model) {
        switch (model) {
            case "e63e64": {
                _model = "e60e61";
                break;
            }
            case "e85": {
                _model = "e83";
                break;
            }
            case "e90": {
                _model = "e87";
                break;
            }
            default: {
                _model = model;
            }
        }
    }

    public String getNavigationXML() {
        String navigationXML = null;
        String xmlLocation = _root + _model + "/tree/files.zip";
        File file = new File(xmlLocation);
        ZipFile zipFile = null;
        ZipEntry entry = null;
        try {
            zipFile = new ZipFile(file);
            entry = zipFile.entries().nextElement();
            InputStream inputstream = zipFile.getInputStream(entry);
            Scanner scanner = new Scanner(inputstream, "UTF-8");
            navigationXML = scanner.useDelimiter("\\A").next();
            inputstream.close();
            scanner.close();
            zipFile.close();
        }
        catch (IOException ex) {
            _logger.error("Error while loading navigation xml", (Throwable)ex);
        }
        return navigationXML;
    }

    public static String getSVGLocation() {
        return _svgLocation;
    }

    public static String getHTMLLocation() {
        return _htmlLocation;
    }

    public static String getCSSLocation() {
        return _cssLocation;
    }

    public static String getImageLocation() {
        return _imagesLocation;
    }

    public static String getZiImageLocation() {
        return _ziImageLocation;
    }

    public static Icon getIconForId(int id) {
        return _iconMap.get(id);
    }

    public static Image getLogo() {
        return _bmwIcon.getImage();
    }

    public static ImageIcon getSplashImage() {
        return new ImageIcon(_splashImage);
    }

    private void buildIconList() {
        _iconMap.put(11, new ImageIcon("res/images/icons/icon_schem.gif"));
        _iconMap.put(13, new ImageIcon("res/images/icons/icon_comploc.gif"));
        _iconMap.put(15, new ImageIcon("res/images/icons/icon_connector.gif"));
        _iconMap.put(17, new ImageIcon("res/images/icons/icon_pin.gif"));
        _iconMap.put(19, new ImageIcon("res/images/icons/icon_specval.gif"));
        _iconMap.put(21, new ImageIcon("res/images/icons/icon_help.gif"));
        _iconMap.put(23, new ImageIcon("res/images/icons/icon_check.gif"));
        _iconMap.put(25, new ImageIcon("res/images/icons/icon_document.gif"));
        _iconMap.put(27, new ImageIcon("res/images/icons/icon_measure.gif"));
        _IdMap.put("res/images/icons/icon_schem.gif", 11);
        _IdMap.put("res/images/icons/icon_comploc.gif", 13);
        _IdMap.put("res/images/icons/icon_connector.gif", 15);
        _IdMap.put("res/images/icons/icon_pin.gif", 17);
        _IdMap.put("res/images/icons/icon_specval.gif", 19);
        _IdMap.put("res/images/icons/icon_help.gif", 21);
        _IdMap.put("res/images/icons/icon_check.gif", 23);
        _IdMap.put("res/images/icons/icon_document.gif", 25);
        _IdMap.put("res/images/icons/icon_measure.gif", 27);
    }

    private void buildModelList() {
        _modelMap.add(new Triplet<String, String, ImageIcon>("e38new", "7 E38 >09/98", new ImageIcon("res/images/models/bmw7_e38.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e38old", "7 E38 03/94 - 09/98", new ImageIcon("res/images/models/bmw7_e38.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e39new", "5 E39 > 09/98", new ImageIcon("res/images/models/bmw5_e39.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e39old", "5 E39 12/95 - 09/98", new ImageIcon("res/images/models/bmw5_e39.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e46", "3 E46", new ImageIcon("res/images/models/bmw3.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e52", "Z8 E52", new ImageIcon("res/images/models/bmwz8_2.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e53", "X5 E53", new ImageIcon("res/images/models/bmwx5.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e60e61", "5 E60 E61", new ImageIcon("res/images/models/bmw5.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e63e64", "6 E63 E64", new ImageIcon("res/images/models/bmw6.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e65e66", "7 E65 E66", new ImageIcon("res/images/models/bmw7.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e70", "X5 E70", new ImageIcon("res/images/models/bmwx5_2.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e83", "X3 E83", new ImageIcon("res/images/models/bmwx3.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e85", "Z4 E85 E86", new ImageIcon("res/images/models/bmwz4.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e87", "1 E81 E82 E87 E88", new ImageIcon("res/images/models/bmw1.jpg")));
        _modelMap.add(new Triplet<String, String, ImageIcon>("e90", "3 E90 E91 E92 E93", new ImageIcon("res/images/models/bmw3_e90.jpg")));
    }

    public static List<Triplet<String, String, Icon>> getModelList() {
        return _modelMap;
    }

    public static Integer getIdforFile(String file) {
        return _IdMap.get(file);
    }

    public static Color getCyanColor() {
        return _cyanColor;
    }

    public static Color getGreyColor() {
        return _greyColor;
    }

    public static Font globalProLight() {
        return _globalProLight;
    }

    public static Font globalProBold() {
        return _globalProBold;
    }

    public static Font globalProRegular() {
        return _globalProRegular;
    }

    public static Font webProBold() {
        return _webProBold;
    }

    public static void shutdown() {
        H2_FS.getInstance().shutdown_h2();
    }

    public static String getModel() {
        return _model;
    }

    static {
        _root = "res/dvd_src/" + Messages.getLanguage() + "/";
        _htmlLocation = _root + "zinfo/";
        _svgLocation = _root + "svg/sp/";
        _cssLocation = _root + "styles";
        _ziImageLocation = _root + "zinfo/";
        _bmwIcon = null;
        _splashImage = null;
        _iconMap = new HashMap();
        _IdMap = new HashMap();
        _modelMap = new ArrayList<Triplet<String, String, Icon>>();
        _cyanColor = new Color(191, 239, 255);
        _greyColor = new Color(74, 74, 74);
        _webProBold = null;
        _globalProBold = null;
        _globalProLight = null;
        _globalProRegular = null;
    }
}

