/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.fs;

import de.bmwrudel.wds.fs.Doublet;
import de.bmwrudel.wds.fs.WdsFS;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.tools.Server;

public class H2_FS {
    private static final Logger _logger = LogManager.getLogger();
    private static H2_FS _instance = null;
    Server _db_server = null;
    Server _web_server = null;

    private H2_FS() {
        try {
            _logger.info("Starting H2 Server...");
            this._db_server = Server.createTcpServer((String[])new String[]{"-tcpPort", "9092", "-tcpAllowOthers", "-baseDir", "res/h2/h2"});
            this._web_server = Server.createWebServer((String[])new String[]{"-webPort", "9098", "-webAllowOthers"});
        }
        catch (SQLException e) {
            _logger.error(e);
        }
    }

    public static H2_FS getInstance() {
        if (_instance == null) {
            _instance = new H2_FS();
        }
        return _instance;
    }

    public void startup_h2() {
        try {
            this._db_server.start();
            this._web_server.start();
        }
        catch (SQLException e) {
            _logger.error(e);
        }
        _logger.info(this._db_server.getStatus());
        _logger.info(this._web_server.getStatus());
    }

    public void shutdown_h2() {
        this._web_server.stop();
        this._db_server.stop();
    }

    private Connection getConnection() {
        Connection conn = null;
        try {
            Class.forName("org.h2.Driver");
            conn = DriverManager.getConnection("jdbc:h2:file:./res/h2/h2", "sa", "sa");
        }
        catch (ClassNotFoundException | SQLException e) {
            _logger.error(e);
        }
        return conn;
    }

    public void add_bookmark(String bookmark, Icon icon, String selectionPath) {
        Connection conn = this.getConnection();
        try {
            PreparedStatement prepStmt = conn.prepareStatement("insert into bookmarks(id, model, bookmark, icon, path) values (?, ?, ?, ?, ?)");
            prepStmt.setInt(1, 1);
            prepStmt.setString(2, WdsFS.getModel());
            prepStmt.setString(3, bookmark);
            prepStmt.setInt(4, WdsFS.getIdforFile(((ImageIcon)icon).getDescription()));
            prepStmt.setString(5, selectionPath);
            prepStmt.executeUpdate();
            _logger.info("Adding new bookmark: " + bookmark);
            prepStmt.close();
            conn.close();
        }
        catch (SQLException e) {
            _logger.error(e);
        }
    }

    public List<Doublet<Integer, String>> getBookmarkList() {
        ArrayList<Doublet<Integer, String>> list = new ArrayList<Doublet<Integer, String>>();
        Connection conn = this.getConnection();
        String stmt = "select id, bookmark, icon from bookmarks where model = ?";
        try {
            PreparedStatement prepStmt = conn.prepareStatement(stmt);
            prepStmt.setString(1, WdsFS.getModel());
            ResultSet rs = prepStmt.executeQuery();
            while (rs.next()) {
                list.add(new Doublet<Integer, String>(rs.getInt(3), rs.getString(2)));
            }
            rs.close();
            prepStmt.close();
            conn.close();
        }
        catch (SQLException e) {
            _logger.error(e);
        }
        return list;
    }
}

