/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.exporter;

import de.bmwrudel.wds.fs.WdsFS;
import de.bmwrudel.wds.gui.JStatusBar;
import de.bmwrudel.wds.localization.Messages;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.print.attribute.standard.MediaSize;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WDSSchemaExporter {
    private static Logger _logger = LogManager.getLogger();

    public static void doExport(String src, String dst, String format, String paperFormat) {
        _logger.info("Requested export format: " + format);
        _logger.info("Source file: " + src);
        _logger.info("Destination file: " + dst);
        _logger.info("Paper format: " + paperFormat);
        MediaSize paperSize = null;
        Float resolution = Float.valueOf(300.0f);
        switch (paperFormat) {
            case "A4": {
                paperSize = MediaSize.ISO.A4;
                break;
            }
            case "A3": {
                paperSize = MediaSize.ISO.A3;
                break;
            }
            case "A2": {
                paperSize = MediaSize.ISO.A2;
            }
        }
        Float width = Float.valueOf(paperSize.getX(25400) * resolution.floatValue());
        Float height = Float.valueOf(paperSize.getY(25400) * resolution.floatValue());
        PNGTranscoder transcoder = null;
        switch (format) {
            case "PNG": {
                transcoder = new PNGTranscoder();
                transcoder.addTranscodingHint(PNGTranscoder.KEY_BACKGROUND_COLOR, (Object)WdsFS.getCyanColor());
                transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)width);
                transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)height);
                transcoder.addTranscodingHint(PNGTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(0.084666f));
                break;
            }
            case "PDF": {
                transcoder = new PDFTranscoder();
                transcoder.addTranscodingHint(PDFTranscoder.KEY_HEIGHT, (Object)width);
                transcoder.addTranscodingHint(PDFTranscoder.KEY_WIDTH, (Object)height);
                transcoder.addTranscodingHint(PDFTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(0.084666f));
                transcoder.addTranscodingHint(PDFTranscoder.KEY_DEVICE_RESOLUTION, (Object)new Float(300.0f));
            }
        }
        TranscoderInput transcoderInput = new TranscoderInput(src);
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(dst);
            TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
            transcoder.transcode(transcoderInput, output);
            ostream.flush();
            ((OutputStream)ostream).close();
            JStatusBar.setMessage(Messages.getString("ScematicExporter.done") + dst);
        }
        catch (IOException | TranscoderException ex) {
            ex.printStackTrace();
        }
    }
}

