/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.exporter;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.itextpdf.tool.xml.exceptions.CssResolverException;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.parser.XMLParserListener;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.AbstractImageProvider;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.ImageProvider;
import com.itextpdf.tool.xml.pipeline.html.LinkProvider;
import de.bmwrudel.wds.fs.WdsFS;
import de.bmwrudel.wds.gui.JStatusBar;
import de.bmwrudel.wds.localization.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class WDSDocumentExporter {
    private static Logger _logger = LogManager.getLogger();

    public static void doExport(String srcFile, String dstFile) {
        com.itextpdf.text.Document document = new com.itextpdf.text.Document();
        PdfWriter writer = null;
        try {
            writer = PdfWriter.getInstance((com.itextpdf.text.Document)document, (OutputStream)new FileOutputStream(dstFile));
            document.open();
            document.setPageSize(PageSize.A4);
            document.addAuthor("BMW AG");
            document.addCreator("BMW WDS 12 NG");
            document.addCreationDate();
            CSSResolver cssResolver = XMLWorkerHelper.getInstance().getDefaultCssResolver(true);
            for (String css : WDSDocumentExporter.getStyleSheets(srcFile)) {
                String cssPath = WdsFS.getCSSLocation() + css.replace("../styles", "");
                cssResolver.addCssFile(cssPath, true);
            }
            PdfWriterPipeline pdf = new PdfWriterPipeline(document, writer);
            HtmlPipelineContext htmlPipeContext = new HtmlPipelineContext(null);
            htmlPipeContext.setTagFactory(Tags.getHtmlTagProcessorFactory());
            htmlPipeContext.setImageProvider((ImageProvider)new AbstractImageProvider(){

                public String getImageRootPath() {
                    String ziImagePath = WdsFS.getZiImageLocation();
                    _logger.info("ziImagePath :" + ziImagePath);
                    return ziImagePath;
                }
            });
            htmlPipeContext.setLinkProvider(new LinkProvider(){

                public String getLinkRoot() {
                    String ziImagePath = WdsFS.getZiImageLocation();
                    _logger.info("ziImagePath :" + ziImagePath);
                    return ziImagePath;
                }
            });
            HtmlPipeline html = new HtmlPipeline(htmlPipeContext, (Pipeline)pdf);
            CssResolverPipeline css = new CssResolverPipeline(cssResolver, (Pipeline)html);
            XMLWorker worker = new XMLWorker((Pipeline)css, true);
            XMLParser p = new XMLParser((XMLParserListener)worker);
            p.parse((InputStream)new FileInputStream(new File(srcFile)), true);
            document.close();
            JStatusBar.setMessage(Messages.getString("DocumentExporter.done") + dstFile);
        }
        catch (DocumentException | CssResolverException | IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> getStyleSheets(String src) {
        ArrayList<String> cssList = new ArrayList<String>();
        File htmlFile = new File(src);
        try {
            Document document = Jsoup.parse((File)htmlFile, (String)"utf-8");
            Elements elements = document.getElementsByTag("link");
            for (Element element : elements) {
                String attr = element.attr("href");
                cssList.add(attr);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return cssList;
    }
}

