/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.dialogs;

import de.bmwrudel.wds.exporter.WDSSchemaExporter;
import de.bmwrudel.wds.localization.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;

public class WDSScematicExportDialog
extends JDialog {
    private static final long serialVersionUID = -804297489277168976L;
    private ButtonGroup _grpPaperFormat = new ButtonGroup();
    private ButtonGroup _grpFormat = new ButtonGroup();
    private JTextField _targetPath = new JTextField();
    private String _svgSourceUri;
    private String _svgName;
    private File _selectedFile;

    public WDSScematicExportDialog() {
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setTitle(Messages.getString("ScematicExportDialog.title"));
        this.setSize(444, 244);
        this.setResizable(false);
        this.setLocation(100, 100);
        this.getContentPane().setBackground(new Color(255, 255, 255));
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "Center");
        panel.setLayout(null);
        JLabel lblPaperSize = new JLabel(Messages.getString("ScematicExportDialog.lblPaperSize.text"));
        lblPaperSize.setFont(new Font("Tahoma", 1, 12));
        lblPaperSize.setBounds(6, 11, 80, 14);
        panel.add(lblPaperSize);
        JRadioButton a4 = new JRadioButton(Messages.getString("ScematicExportDialog.DIN_A4.text"));
        a4.setBounds(6, 25, 109, 23);
        a4.setActionCommand(Messages.getString("ScematicExportDialog.DIN_A4.command"));
        a4.setSelected(true);
        panel.add(a4);
        JRadioButton a3 = new JRadioButton(Messages.getString("ScematicExportDialog.DIN_A3.text"));
        a3.setBounds(6, 43, 109, 23);
        a3.setActionCommand(Messages.getString("ScematicExportDialog.DIN_A3.command"));
        panel.add(a3);
        JRadioButton a2 = new JRadioButton(Messages.getString("ScematicExportDialog.DIN_A2.text"));
        a2.setBounds(6, 61, 109, 23);
        a2.setActionCommand(Messages.getString("ScematicExportDialog.DIN_A2.command"));
        panel.add(a2);
        this._grpPaperFormat.add(a4);
        this._grpPaperFormat.add(a3);
        this._grpPaperFormat.add(a2);
        JLabel lblFormat = new JLabel(Messages.getString("ScematicExportDialog.lblFormat.text"));
        lblFormat.setFont(new Font("Tahoma", 1, 12));
        lblFormat.setBounds(130, 11, 55, 14);
        panel.add(lblFormat);
        JRadioButton rdbtnPNG = new JRadioButton(Messages.getString("ScematicExportDialog.rdbtnPNG.text"));
        rdbtnPNG.setBounds(130, 25, 109, 23);
        rdbtnPNG.setSelected(true);
        rdbtnPNG.setActionCommand("PNG");
        rdbtnPNG.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WDSScematicExportDialog.this._targetPath.setText(WDSScematicExportDialog.this._targetPath.getText().replace(".pdf", ".png"));
                }
            }
        });
        panel.add(rdbtnPNG);
        JRadioButton rdbtnPDF = new JRadioButton(Messages.getString("ScematicExportDialog.rdbtnPDF.text"));
        rdbtnPDF.setBounds(130, 43, 109, 23);
        rdbtnPDF.setActionCommand("PDF");
        rdbtnPDF.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WDSScematicExportDialog.this._targetPath.setText(WDSScematicExportDialog.this._targetPath.getText().replace(".png", ".pdf"));
                }
            }
        });
        panel.add(rdbtnPDF);
        this._grpFormat.add(rdbtnPNG);
        this._grpFormat.add(rdbtnPDF);
        JLabel lblPath = new JLabel(Messages.getString("ScematicExportDialog.lblPath.text"));
        lblPath.setFont(new Font("Verdana", 1, 12));
        lblPath.setBounds(6, 120, 46, 14);
        panel.add(lblPath);
        this._targetPath.setBounds(6, 140, 312, 26);
        this._targetPath.setFont(new Font("Verdana", 0, 12));
        panel.add(this._targetPath);
        JButton btnSelectFile = new JButton(Messages.getString("ScematicExportDialog.btnSelect.text"));
        btnSelectFile.setBounds(319, 141, 109, 23);
        panel.add(btnSelectFile);
        btnSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand;
                JFileChooser chooseFile = new JFileChooser();
                ButtonModel selection = WDSScematicExportDialog.this._grpFormat.getSelection();
                switch (actionCommand = selection.getActionCommand()) {
                    case "PDF": {
                        FileNameExtensionFilter filterPDF = new FileNameExtensionFilter(Messages.getString("ScematicExportDialog.pdfExtFilter.text"), "pdf", "PDF");
                        chooseFile.setFileFilter(filterPDF);
                        break;
                    }
                    case "PNG": {
                        FileNameExtensionFilter filterPNG = new FileNameExtensionFilter(Messages.getString("ScematicExportDialog.pngExtFilter.text"), "png", "PNG");
                        chooseFile.setFileFilter(filterPNG);
                    }
                }
                chooseFile.setSelectedFile(new File(WDSScematicExportDialog.this._svgName + "." + WDSScematicExportDialog.this._grpFormat.getSelection().getActionCommand().toLowerCase()));
                if (chooseFile.showSaveDialog(null) == 0) {
                    JButton source = (JButton)e.getSource();
                    JTextField textField = (JTextField)source.getParent().getComponent(9);
                    String file = chooseFile.getSelectedFile().toString();
                    WDSScematicExportDialog.this._selectedFile = chooseFile.getSelectedFile();
                    textField.setText(file);
                }
            }
        });
        JPanel buttonPane = new JPanel();
        FlowLayout flowLayout = (FlowLayout)buttonPane.getLayout();
        flowLayout.setAlignment(2);
        this.getContentPane().add((Component)buttonPane, "South");
        JButton btnOK = new JButton(Messages.getString("ScematicExportDialog.btnOK.text"));
        buttonPane.add(btnOK);
        JButton btnCancel = new JButton(Messages.getString("ScematicExportDialog.btnCancel.text"));
        btnCancel.setHorizontalAlignment(4);
        buttonPane.add(btnCancel);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WDSScematicExportDialog.this.dispose();
            }
        });
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Path path = Paths.get(WDSScematicExportDialog.this._targetPath.getText(), new String[0]);
                String fileName = path.getFileName().toString().replace("/", "_");
                String directory = path.getParent().toString();
                WDSScematicExportDialog.this._targetPath.setText(directory + File.separator + fileName);
                WDSSchemaExporter.doExport(WDSScematicExportDialog.this._svgSourceUri, WDSScematicExportDialog.this._targetPath.getText(), WDSScematicExportDialog.this._grpFormat.getSelection().getActionCommand(), WDSScematicExportDialog.this._grpPaperFormat.getSelection().getActionCommand());
                WDSScematicExportDialog.this.dispose();
            }
        });
    }

    public void setSourceUri(String uri) {
        this._svgSourceUri = uri;
    }

    @Override
    public void setName(String name) {
        this._svgName = name;
        this._targetPath.setText(FileSystemView.getFileSystemView().getDefaultDirectory().getPath() + File.separator + name + "." + this._grpFormat.getSelection().getActionCommand().toLowerCase());
    }
}

