/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.view;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;
import org.fit.cssbox.layout.InlineReplacedBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.ReplacedImage;
import org.fit.cssbox.swingbox.view.InlineBoxView;

public class InlineReplacedBoxView
extends InlineBoxView {
    private static final Font DEFAULT_FONT = new Font(null, 0, 13);
    private Container container;
    private ReplacedContent content = ((InlineReplacedBox)this.box).getContentObj();
    private ReplacedImage repImage = this.content instanceof ReplacedImage ? (ReplacedImage)this.content : null;
    private String alt = "";
    private String title = "";

    public InlineReplacedBoxView(Element elem) {
        super(elem);
        this.loadElementAttributes();
    }

    private void loadElementAttributes() {
        this.alt = this.box.getElement().getAttribute("alt");
        this.title = this.box.getElement().getAttribute("title");
    }

    @Override
    public void paint(Graphics graphics, Shape allocation) {
        Graphics2D g = (Graphics2D)graphics;
        Rectangle alloc = InlineReplacedBoxView.toRect(allocation);
        if (this.isVisible()) {
            this.paintHighlights(g, alloc);
            this.box.getVisualContext().updateGraphics(g);
            this.box.drawBackground(g);
            if (this.content != null) {
                this.content.draw(g, this.box.getContentWidth(), this.box.getContentHeight());
                if (this.repImage != null && this.repImage.getImage() == null) {
                    if (!"".equals(this.alt)) {
                        g.setFont(DEFAULT_FONT);
                        g.setColor(Color.BLACK);
                    } else {
                        this.drawCross(g);
                    }
                }
            } else {
                this.drawCross(g);
            }
        }
    }

    private void drawCross(Graphics2D g) {
    }

    @Override
    public String getToolTipText(float x, float y, Shape allocation) {
        String tmp;
        Map<String, String> elementAttributes = this.anchor.getProperties();
        String val = "";
        if (this.title != null && !"".equals(this.title)) {
            val = val + "<b>" + this.title + "</b><br>";
        }
        if ((tmp = elementAttributes.get("a_title")) != null && !"".equals(tmp)) {
            val = val + "<i>" + tmp + "</i><br>";
        }
        if ((tmp = elementAttributes.get("a_href")) != null && !"".equals(tmp)) {
            val = val + tmp;
        }
        return "".equals(val) ? null : "<html>" + val + "</html>";
    }

    @Override
    public boolean isVisible() {
        return this.box.isDisplayed() && this.box.isVisible();
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.container = this.getContainer();
            if (this.repImage != null) {
                this.repImage.setContainer(this.container);
            }
        } else {
            this.repImage = null;
            this.content = null;
            this.container = null;
        }
    }

    @Override
    protected View getViewAtPoint(int x, int y, Rectangle alloc) {
        Rectangle rec = this.box.getAbsoluteBounds();
        if (rec.contains(x, y)) {
            return this;
        }
        return null;
    }

    @Override
    protected void setPropertiesFromAttributes(AttributeSet attr) {
        super.setPropertiesFromAttributes(attr);
        if (attr != null) {
            // empty if block
        }
    }

    @Override
    protected SimpleAttributeSet createAttributes() {
        SimpleAttributeSet res = super.createAttributes();
        res.addAttribute("attribute_replaced_content", this.content);
        return res;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc;
        Rectangle rectangle = alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        if (x < (float)(alloc.x + alloc.width / 2)) {
            bias[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        bias[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r;
            Rectangle rectangle = r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        throw new BadLocationException(pos + " not in range " + p0 + "," + p1, pos);
    }

    private void paintHighlights(Graphics g, Shape shape) {
        JTextComponent tc;
        Highlighter h;
        if (this.container instanceof JTextComponent && (h = (tc = (JTextComponent)this.container).getHighlighter()) instanceof LayeredHighlighter) {
            ((LayeredHighlighter)h).paintLayeredHighlights(g, this.getStartOffset(), this.getEndOffset(), shape, tc, this);
        }
    }
}

