/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.testing;

import cz.vutbr.web.css.MediaSpec;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.testing.ImageComparator;
import org.fit.cssbox.testing.TestBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReferenceTestCase
implements Callable<Float> {
    private static Logger log = LoggerFactory.getLogger(ReferenceTestCase.class);
    private String name;
    private String urlstring;
    private boolean saveImages;
    private TestBatch batch;
    private DocumentSource docSource;
    private DOMSource parser;
    private String mediaType = "screen";
    private Dimension windowSize = new Dimension(1200, 600);
    private boolean cropWindow = false;
    private boolean loadImages = true;
    private boolean loadBackgroundImages = true;

    public ReferenceTestCase(String name, String urlstring) {
        this.name = name;
        this.urlstring = urlstring;
        this.saveImages = false;
    }

    public ReferenceTestCase(String name, String urlstring, boolean saveImages) {
        this.name = name;
        this.urlstring = urlstring;
        this.saveImages = saveImages;
    }

    public void setBatch(TestBatch batch) {
        this.batch = batch;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Float call() throws Exception {
        return Float.valueOf(this.performTest());
    }

    public float performTest() throws IOException, SAXException {
        log.debug("Loading test {}", (Object)this.urlstring);
        Document doc = this.loadDocument(this.urlstring);
        URL srcurl = this.docSource.getURL();
        URL refurl = this.extractReference(doc, this.docSource.getURL());
        BufferedImage testImg = this.renderDocument(doc);
        this.closeDocument();
        log.debug("  -- reference result {}", (Object)refurl);
        Document refDoc = this.loadDocument(refurl.toString());
        BufferedImage refImg = this.renderDocument(refDoc);
        this.closeDocument();
        ImageComparator ic = new ImageComparator(testImg, refImg);
        log.debug(" -- error rate {}", (Object)Float.valueOf(ic.getErrorRate()));
        if (this.saveImages && ic.getErrorRate() > 0.0f) {
            File path = new File(srcurl.getFile());
            this.saveImage(testImg, "/tmp/test-" + path.getName() + ".srcA.png");
            this.saveImage(refImg, "/tmp/test-" + path.getName() + ".srcB.png");
            this.saveImage(ic.getDifferenceImage(), "/tmp/test-" + path.getName() + ".diff.png");
        }
        if (ic.getErrorDescription() != null) {
            log.error(this.name + ": " + ic.getErrorDescription());
        }
        if (this.batch != null) {
            this.batch.reportCompletion(this);
        }
        return ic.getErrorRate();
    }

    private Document loadDocument(String urlstring) throws IOException, SAXException {
        this.docSource = new DefaultDocumentSource(urlstring);
        this.parser = new DefaultDOMSource(this.docSource);
        Document doc = this.parser.parse();
        return doc;
    }

    private void closeDocument() throws IOException {
        if (this.docSource != null) {
            this.docSource.close();
        }
    }

    private BufferedImage renderDocument(Document doc) {
        MediaSpec media = new MediaSpec(this.mediaType);
        media.setDimensions((float)this.windowSize.width, (float)this.windowSize.height);
        media.setDeviceDimensions((float)this.windowSize.width, (float)this.windowSize.height);
        DOMAnalyzer da = new DOMAnalyzer(doc, this.docSource.getURL());
        da.setMediaSpec(media);
        da.attributesToStyles();
        da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.formsStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.getStyleSheets();
        BrowserCanvas contentCanvas = new BrowserCanvas(da.getRoot(), da, this.docSource.getURL());
        contentCanvas.setAutoMediaUpdate(false);
        contentCanvas.getConfig().setClipViewport(this.cropWindow);
        contentCanvas.getConfig().setLoadImages(this.loadImages);
        contentCanvas.getConfig().setLoadBackgroundImages(this.loadBackgroundImages);
        contentCanvas.createLayout(this.windowSize);
        return contentCanvas.getImage();
    }

    private URL extractReference(Document doc, URL baseURL) {
        NodeList links = doc.getElementsByTagName("link");
        String href = null;
        for (int i = 0; i < links.getLength(); ++i) {
            Element link = (Element)links.item(i);
            if (!"match".equalsIgnoreCase(link.getAttribute("rel"))) continue;
            href = link.getAttribute("href");
            break;
        }
        if (href != null && !href.trim().isEmpty()) {
            href = href.trim();
            try {
                return new URL(baseURL, href);
            }
            catch (MalformedURLException e) {
                log.warn("Invalid reference URL: {}", (Object)href);
                return null;
            }
        }
        return null;
    }

    private void saveImage(BufferedImage img, String outfile) {
        try {
            FileOutputStream os = new FileOutputStream(outfile);
            ImageIO.write((RenderedImage)img, "png", os);
            os.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

