/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.testing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;

public class ReferenceResults
extends LinkedHashMap<String, Float> {
    private static final long serialVersionUID = 1L;
    public static final float SUCCESS_THRESHOLD = 0.001f;
    public static final float COMPARISON_THRESHOLD = 0.001f;
    private int successCnt;
    private int failCnt;
    private int fatalCnt;

    public ReferenceResults() {
        try {
            this.fatalCnt = 0;
            this.failCnt = 0;
            this.successCnt = 0;
            this.loadCSV(this.getClass().getResourceAsStream("/test_reference.csv"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getSuccessCnt() {
        return this.successCnt;
    }

    public int getFailCnt() {
        return this.failCnt;
    }

    public int getFatalCnt() {
        return this.fatalCnt;
    }

    private void loadCSV(InputStream is) throws IOException {
        String line;
        BufferedReader read = new BufferedReader(new InputStreamReader(is));
        while ((line = read.readLine()) != null) {
            String[] vals = line.split(",");
            float val = Float.parseFloat(vals[1]);
            this.put(vals[0], Float.valueOf(val));
            if (val <= 0.001f) {
                ++this.successCnt;
            } else {
                ++this.failCnt;
            }
            if (val != 1.0f) continue;
            ++this.fatalCnt;
        }
    }
}

