/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.testing;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class ImageComparator {
    private BufferedImage diff;
    private int totalcnt;
    private int diffcnt;
    private String errorDescr = null;

    public ImageComparator(BufferedImage img1, BufferedImage img2) {
        this.diff = this.createDifferenceImage(img1, img2);
    }

    public float getErrorRate() {
        return (float)this.diffcnt / (float)this.totalcnt;
    }

    public String getErrorDescription() {
        return this.errorDescr;
    }

    public BufferedImage getDifferenceImage() {
        return this.diff;
    }

    private BufferedImage createDifferenceImage(BufferedImage img1, BufferedImage img2) {
        int w1 = img1.getWidth();
        int h1 = img1.getHeight();
        int w2 = img2.getWidth();
        int h2 = img2.getHeight();
        if (w1 != w2 || h1 != h2) {
            this.errorDescr = "Image sizes don't match";
            this.totalcnt = 1;
            this.diffcnt = 1;
            return img1;
        }
        int highlight = Color.MAGENTA.getRGB();
        int[] p1 = img1.getRGB(0, 0, w1, h1, null, 0, w1);
        int[] p2 = img2.getRGB(0, 0, w1, h1, null, 0, w1);
        this.totalcnt = p1.length;
        this.diffcnt = 0;
        for (int i = 0; i < p1.length; ++i) {
            if (p1[i] == p2[i]) continue;
            p1[i] = highlight;
            ++this.diffcnt;
        }
        BufferedImage out = new BufferedImage(w1, h1, 1);
        out.setRGB(0, 0, w1, h1, p1, 0, w1);
        return out;
    }
}

