/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.render;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermColor;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import org.fit.cssbox.layout.BackgroundImage;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.LengthSet;
import org.fit.cssbox.layout.ReplacedBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.ReplacedImage;
import org.fit.cssbox.layout.ReplacedText;
import org.fit.cssbox.layout.TextBox;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.layout.VisualContext;
import org.fit.cssbox.misc.Base64Coder;
import org.fit.cssbox.render.BoxRenderer;

public class SVGRenderer
implements BoxRenderer {
    private PrintWriter out;
    private int rootw;
    private int rooth;
    private int idcounter = 1;

    public SVGRenderer(int rootWidth, int rootHeight, Writer out) {
        this.rootw = rootWidth;
        this.rooth = rootHeight;
        this.out = new PrintWriter(out);
        this.writeHeader();
    }

    @Override
    public void startElementContents(ElementBox elem) {
        if (elem instanceof BlockBox && ((BlockBox)elem).getOverflow() != BlockBox.OVERFLOW_VISIBLE) {
            Rectangle cb = elem.getClippedContentBounds();
            String clip = "cssbox-clip-" + this.idcounter;
            this.out.print("<clipPath id=\"" + clip + "\">");
            this.out.print("<rect x=\"" + cb.x + "\" y=\"" + cb.y + "\" width=\"" + cb.width + "\" height=\"" + cb.height + "\" />");
            this.out.println("</clipPath>");
            this.out.println("<g id=\"cssbox-obj-" + this.idcounter + "\" clip-path=\"url(#" + clip + ")\">");
            ++this.idcounter;
        }
    }

    @Override
    public void finishElementContents(ElementBox elem) {
        if (elem instanceof BlockBox && ((BlockBox)elem).getOverflow() != BlockBox.OVERFLOW_VISIBLE) {
            this.out.println("</g>");
        }
    }

    @Override
    public void renderElementBackground(ElementBox eb) {
        Color bg;
        Rectangle bb = eb.getAbsoluteBorderBounds();
        if (eb instanceof Viewport) {
            bb = eb.getClippedBounds();
        }
        if ((bg = eb.getBgcolor()) != null) {
            String style = "stroke:none;fill-opacity:1;fill:" + this.colorString(bg);
            this.out.println("<rect x=\"" + bb.x + "\" y=\"" + bb.y + "\" width=\"" + bb.width + "\" height=\"" + bb.height + "\" style=\"" + (String)style + "\" />");
        }
        if (eb.getBackgroundImages() != null && eb.getBackgroundImages().size() > 0) {
            for (BackgroundImage bimg : eb.getBackgroundImages()) {
                BufferedImage img = bimg.getBufferedImage();
                if (img == null) continue;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)img, "png", os);
                }
                catch (IOException e) {
                    this.out.println("<!-- I/O error: " + e.getMessage() + " -->");
                }
                char[] data = Base64Coder.encode(os.toByteArray());
                String imgdata = "data:image/png;base64," + new String(data);
                int ix = bb.x + eb.getBorder().left;
                int iy = bb.y + eb.getBorder().top;
                int iw = bb.width - eb.getBorder().right - eb.getBorder().left;
                int ih = bb.height - eb.getBorder().bottom - eb.getBorder().top;
                this.out.println("<image x=\"" + ix + "\" y=\"" + iy + "\" width=\"" + iw + "\" height=\"" + ih + "\" xlink:href=\"" + imgdata + "\" />");
            }
        }
        LengthSet borders = eb.getBorder();
        if (borders.top > 0) {
            this.writeBorderSVG(eb, bb.x, bb.y, bb.x + bb.width, bb.y, "top", borders.top, 0, borders.top / 2);
        }
        if (borders.right > 0) {
            this.writeBorderSVG(eb, bb.x + bb.width, bb.y, bb.x + bb.width, bb.y + bb.height, "right", borders.right, -borders.right / 2, 0);
        }
        if (borders.bottom > 0) {
            this.writeBorderSVG(eb, bb.x, bb.y + bb.height, bb.x + bb.width, bb.y + bb.height, "bottom", borders.bottom, 0, -borders.bottom / 2);
        }
        if (borders.left > 0) {
            this.writeBorderSVG(eb, bb.x, bb.y, bb.x, bb.y + bb.height, "left", borders.left, borders.left / 2, 0);
        }
    }

    @Override
    public void renderTextContent(TextBox text) {
        Rectangle b = text.getAbsoluteBounds();
        VisualContext ctx = text.getVisualContext();
        String style = "font-size:" + ctx.getFontSize() + "pt;" + "font-weight:" + (ctx.getFont().isBold() ? "bold" : "normal") + ";" + "font-variant:" + (ctx.getFont().isItalic() ? "italic" : "normal") + ";" + "font-family:" + ctx.getFont().getFamily() + ";" + "fill:" + this.colorString(ctx.getColor()) + ";" + "stroke:none";
        if (!ctx.getTextDecoration().isEmpty()) {
            style = style + ";text-decoration:" + ctx.getTextDecorationString();
        }
        this.out.println("<text x=\"" + b.x + "\" y=\"" + (b.y + text.getBaselineOffset()) + "\" width=\"" + b.width + "\" height=\"" + b.height + "\" style=\"" + style + "\">" + this.htmlEntities(text.getText()) + "</text>");
    }

    @Override
    public void renderReplacedContent(ReplacedBox box) {
        ReplacedContent cont = box.getContentObj();
        if (cont != null) {
            if (cont instanceof ReplacedImage) {
                BufferedImage img = ((ReplacedImage)cont).getBufferedImage();
                if (img != null) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)img, "png", os);
                    }
                    catch (IOException e) {
                        this.out.println("<!-- I/O error: " + e.getMessage() + " -->");
                    }
                    char[] data = Base64Coder.encode(os.toByteArray());
                    String imgdata = "data:image/png;base64," + new String(data);
                    Rectangle cb = ((Box)((Object)box)).getAbsoluteContentBounds();
                    this.out.println("<image x=\"" + cb.x + "\" y=\"" + cb.y + "\" width=\"" + cb.width + "\" height=\"" + cb.height + "\" xlink:href=\"" + imgdata + "\" />");
                }
            } else if (cont instanceof ReplacedText) {
                Rectangle cb = ((Box)((Object)box)).getClippedBounds();
                String clip = "cssbox-clip-" + this.idcounter;
                this.out.print("<clipPath id=\"" + clip + "\">");
                this.out.print("<rect x=\"" + cb.x + "\" y=\"" + cb.y + "\" width=\"" + cb.width + "\" height=\"" + cb.height + "\" />");
                this.out.println("</clipPath>");
                this.out.println("<g id=\"cssbox-obj-" + this.idcounter++ + "\" clip-path=\"url(#" + clip + ")\">");
                ReplacedText rt = (ReplacedText)cont;
                rt.getContentViewport().draw(this);
                this.out.println("</g>");
            }
        }
    }

    @Override
    public void close() {
        this.writeFooter();
    }

    private void writeHeader() {
        this.out.println("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        this.out.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20010904//EN\" \"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">");
        this.out.println("<!-- Rendered by CSSBox http://cssbox.sourceforge.net -->");
        this.out.println("<svg xmlns=\"http://www.w3.org/2000/svg\"");
        this.out.println("     xmlns:xlink=\"http://www.w3.org/1999/xlink\" xml:space=\"preserve\"");
        this.out.println("         width=\"" + this.rootw + "\" height=\"" + this.rooth + "px\"");
        this.out.println("         viewBox=\"0 0 " + this.rootw + " " + this.rooth + "\"");
        this.out.println("         zoomAndPan=\"disable\" >");
    }

    private void writeFooter() {
        this.out.println("</svg>");
    }

    private void writeBorderSVG(ElementBox eb, int x1, int y1, int x2, int y2, String side, int width, int right, int down) {
        CSSProperty.BorderColor bclr = (CSSProperty.BorderColor)eb.getStyle().getProperty("border-" + side + "-color");
        TermColor tclr = (TermColor)eb.getStyle().getValue(TermColor.class, "border-" + side + "-color");
        CSSProperty.BorderStyle bst = (CSSProperty.BorderStyle)eb.getStyle().getProperty("border-" + side + "-style");
        if (bst != CSSProperty.BorderStyle.HIDDEN && bclr != CSSProperty.BorderColor.TRANSPARENT) {
            Color clr = null;
            if (tclr != null) {
                clr = (Color)tclr.getValue();
            }
            if (clr == null && (clr = eb.getVisualContext().getColor()) == null) {
                clr = Color.BLACK;
            }
            String stroke = "";
            stroke = bst == CSSProperty.BorderStyle.SOLID ? "stroke-width:" + width : (bst == CSSProperty.BorderStyle.DOTTED ? "stroke-width:" + width + ";stroke-dasharray:" + width + "," + width : (bst == CSSProperty.BorderStyle.DASHED ? "stroke-width:" + width + ";stroke-dasharray:" + 3 * width + "," + width : (bst == CSSProperty.BorderStyle.DOUBLE ? "stroke-width:" + width : "stroke-width:" + width)));
            String coords = "M " + (x1 + right) + "," + (y1 + down) + " L " + (x2 + right) + "," + (y2 + down);
            String style = "fill:none;stroke:" + this.colorString(clr) + ";" + stroke;
            this.out.println("<path style=\"" + style + "\" d=\"" + coords + "\" />");
        }
    }

    private String colorString(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private String htmlEntities(String s) {
        return s.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;");
    }
}

