/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.TermLengthOrPercent;
import java.awt.Graphics2D;
import org.fit.cssbox.layout.BlockBox;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.CSSDecoder;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.Inline;
import org.fit.cssbox.layout.InlineBox;
import org.fit.cssbox.layout.InlineElement;
import org.fit.cssbox.layout.LineBox;
import org.fit.cssbox.layout.VisualContext;
import org.w3c.dom.Element;

public class InlineBlockBox
extends BlockBox
implements InlineElement {
    private CSSProperty.VerticalAlign valign;
    private LineBox linebox;
    protected int baseline;
    private int availw;
    private boolean force;

    public InlineBlockBox(Element n, Graphics2D g, VisualContext ctx) {
        super(n, g, ctx);
        this.isblock = false;
    }

    public InlineBlockBox(InlineBox src) {
        super(src);
        this.isblock = false;
    }

    @Override
    public void setStyle(NodeData s) {
        super.setStyle(s);
        this.loadInlineStyle();
    }

    @Override
    public CSSProperty.VerticalAlign getVerticalAlign() {
        return this.valign;
    }

    @Override
    public void setLineBox(LineBox linebox) {
        this.linebox = linebox;
    }

    @Override
    public LineBox getLineBox() {
        return this.linebox;
    }

    @Override
    public int getLineboxOffset() {
        return 0;
    }

    @Override
    public int getMaxLineHeight() {
        return this.getHeight();
    }

    @Override
    public int getBaselineOffset() {
        return this.baseline;
    }

    @Override
    public int getBelowBaseline() {
        return this.getHeight() - this.baseline;
    }

    @Override
    public int getTotalLineHeight() {
        return this.getHeight();
    }

    @Override
    public int getHalfLead() {
        return 0;
    }

    @Override
    public int getFirstLineLength() {
        return this.getMaximalContentWidth();
    }

    @Override
    public int getLastLineLength() {
        return this.getMaximalContentWidth();
    }

    @Override
    public boolean containsLineBreak() {
        return false;
    }

    @Override
    public boolean finishedByLineBreak() {
        return false;
    }

    @Override
    public boolean doLayout(int availw, boolean force, boolean linestart) {
        this.availw = availw;
        this.force = force;
        super.doLayout(availw, force, linestart);
        if (force || this.fitsSpace()) {
            this.baseline = this.getLastInlineBoxBaseline(this);
            if (this.baseline == -1) {
                this.baseline = this.getHeight();
            } else {
                this.baseline += this.getContentOffsetY();
                if (this.baseline > this.getHeight()) {
                    this.baseline = this.getHeight();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void layoutInline() {
        if (this.force || this.fitsSpace()) {
            super.layoutInline();
        }
    }

    @Override
    protected void layoutBlocks() {
        if (this.force || this.fitsSpace()) {
            super.layoutBlocks();
        }
    }

    private boolean fitsSpace() {
        return this.availw >= this.totalWidth();
    }

    @Override
    public boolean hasFixedWidth() {
        return this.wset;
    }

    @Override
    public int getMinimalContentWidthLimit() {
        int ret = this.wset ? this.content.width : (this.min_size.width != -1 ? this.min_size.width : 0);
        return ret;
    }

    @Override
    protected void computeWidthsInFlow(TermLengthOrPercent width, boolean auto, boolean exact, int contw, boolean update) {
        CSSDecoder dec = new CSSDecoder(this.ctx);
        if (width == null) {
            auto = true;
        }
        boolean mleftauto = this.style.getProperty("margin-left") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mleft = this.getLengthValue("margin-left");
        boolean mrightauto = this.style.getProperty("margin-right") == CSSProperty.Margin.AUTO;
        TermLengthOrPercent mright = this.getLengthValue("margin-right");
        this.preferredWidth = -1;
        if (!this.widthComputed) {
            update = false;
        }
        if (auto) {
            if (exact) {
                this.wset = false;
            }
            if (!update) {
                this.content.width = dec.getLength(width, auto, 0, 0, contw);
            }
            this.preferredWidth = -1;
        } else {
            if (exact) {
                this.wset = true;
                this.wrelative = width.isPercentage();
            }
            this.content.width = dec.getLength(width, auto, 0, 0, contw);
        }
        this.margin.left = dec.getLength(mleft, mleftauto, 0, 0, contw);
        this.margin.right = dec.getLength(mright, mrightauto, 0, 0, contw);
    }

    @Override
    public void absolutePositions() {
        this.updateStackingContexts();
        if (this.isDisplayed()) {
            this.absbounds.x = this.getParent().getAbsoluteContentX() + this.bounds.x;
            this.absbounds.y = this.valign == CSSProperty.VerticalAlign.TOP ? this.linebox.getAbsoluteY() - this.getContentOffsetY() : (this.valign == CSSProperty.VerticalAlign.BOTTOM ? this.linebox.getAbsoluteY() + this.linebox.getTotalLineHeight() - this.getContentHeight() - this.getContentOffsetY() : this.getParent().getAbsoluteContentY() + this.bounds.y);
            if (this.position == POS_RELATIVE) {
                this.absbounds.x = this.absbounds.x + (this.leftset ? this.coords.left : -this.coords.right);
                this.absbounds.y = this.absbounds.y + (this.topset ? this.coords.top : -this.coords.bottom);
            }
            this.absbounds.width = this.bounds.width;
            this.absbounds.height = this.bounds.height;
            for (int i = this.startChild; i < this.endChild; ++i) {
                this.getSubBox(i).absolutePositions();
            }
        }
    }

    protected void loadInlineStyle() {
        this.valign = (CSSProperty.VerticalAlign)this.style.getProperty("vertical-align");
        if (this.valign == null) {
            this.valign = CSSProperty.VerticalAlign.BASELINE;
        }
    }

    @Override
    public void draw(Box.DrawStage turn) {
        if (this.displayed && !this.formsStackingContext()) {
            switch (turn) {
                case DRAW_NONINLINE: 
                case DRAW_FLOAT: {
                    break;
                }
                case DRAW_INLINE: {
                    if (this.isVisible()) {
                        this.getViewport().getRenderer().renderElementBackground(this);
                    }
                    this.drawStackingContext(true);
                }
            }
        }
    }

    private int getLastInlineBoxBaseline(ElementBox root) {
        Box box = null;
        for (int i = root.getSubBoxNumber() - 1; i >= 0 && !(box = root.getSubBox(i)).isInFlow(); --i) {
            box = null;
        }
        if (box != null) {
            if (box instanceof Inline) {
                return box.getContentY() + ((Inline)((Object)box)).getBaselineOffset();
            }
            return box.getContentY() + this.getLastInlineBoxBaseline((ElementBox)box);
        }
        return -1;
    }
}

