/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import java.util.HashMap;
import java.util.Map;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;

public class BrowserConfig {
    private boolean loadImages = true;
    private boolean loadBackgroundImages = true;
    private int imageLoadTimeout = 500;
    private boolean useHTML = true;
    private boolean replaceImagesWithAlt = false;
    private boolean clipViewport = false;
    private Class<? extends DocumentSource> documentSourceClass = DefaultDocumentSource.class;
    private Class<? extends DOMSource> domSourceClass = DefaultDOMSource.class;
    private Map<String, String> defaultFonts;

    public BrowserConfig() {
        this.initDefaultFonts();
    }

    public boolean getLoadImages() {
        return this.loadImages;
    }

    public void setLoadImages(boolean loadImages) {
        this.loadImages = loadImages;
    }

    public boolean getLoadBackgroundImages() {
        return this.loadBackgroundImages;
    }

    public void setLoadBackgroundImages(boolean loadBackgroundImages) {
        this.loadBackgroundImages = loadBackgroundImages;
    }

    public int getImageLoadTimeout() {
        return this.imageLoadTimeout;
    }

    public void setImageLoadTimeout(int imageLoadTimeout) {
        this.imageLoadTimeout = imageLoadTimeout;
    }

    public boolean getUseHTML() {
        return this.useHTML;
    }

    public void setUseHTML(boolean useHTML) {
        this.useHTML = useHTML;
    }

    public boolean getReplaceImagesWithAlt() {
        return this.replaceImagesWithAlt;
    }

    public void setReplaceImagesWithAlt(boolean replaceImagesWithAlt) {
        this.replaceImagesWithAlt = replaceImagesWithAlt;
    }

    public boolean getClipViewport() {
        return this.clipViewport;
    }

    public void setClipViewport(boolean clipViewport) {
        this.clipViewport = clipViewport;
    }

    public void registerDocumentSource(Class<? extends DocumentSource> documentSourceClass) {
        this.documentSourceClass = documentSourceClass;
    }

    public Class<? extends DocumentSource> getDocumentSourceClass() {
        return this.documentSourceClass;
    }

    public void registerDOMSource(Class<? extends DOMSource> domSourceClass) {
        this.domSourceClass = domSourceClass;
    }

    public Class<? extends DOMSource> getDOMSourceClass() {
        return this.domSourceClass;
    }

    public void setDefaultFont(String logical, String physical) {
        this.defaultFonts.put(logical, physical);
    }

    public String getDefaultFont(String logical) {
        return this.defaultFonts.get(logical);
    }

    protected void initDefaultFonts() {
        this.defaultFonts = new HashMap<String, String>(3);
        this.defaultFonts.put("Serif", "Serif");
        this.defaultFonts.put("SansSerif", "SansSerif");
        this.defaultFonts.put("Monospaced", "Monospaced");
    }
}

