/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.demo;

import java.awt.Dimension;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DOMSource;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.TextBox;
import org.w3c.dom.Document;

public class TextBoxes {
    private static void printTextBoxes(Box root) {
        if (root instanceof TextBox) {
            TextBox text = (TextBox)root;
            System.out.println("x=" + text.getAbsoluteBounds().x + " y=" + text.getAbsoluteBounds().y + " text=" + text.getText());
        } else if (root instanceof ElementBox) {
            ElementBox el = (ElementBox)root;
            for (int i = el.getStartChild(); i < el.getEndChild(); ++i) {
                TextBoxes.printTextBoxes(el.getSubBox(i));
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: TextBoxes <url>");
            System.exit(0);
        }
        try {
            DefaultDocumentSource docSource = new DefaultDocumentSource(args[0]);
            DefaultDOMSource parser = new DefaultDOMSource(docSource);
            Document doc = ((DOMSource)parser).parse();
            DOMAnalyzer da = new DOMAnalyzer(doc, ((DocumentSource)docSource).getURL());
            da.attributesToStyles();
            da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
            da.getStyleSheets();
            BrowserCanvas browser = new BrowserCanvas(da.getRoot(), da, ((DocumentSource)docSource).getURL());
            browser.getConfig().setLoadImages(false);
            browser.getConfig().setLoadBackgroundImages(false);
            browser.createLayout(new Dimension(1000, 600));
            TextBoxes.printTextBoxes(browser.getViewport());
            ((DocumentSource)docSource).close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

