/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.listeners;

import de.bmwrudel.wds.dialogs.WDSSearchResultDialog;
import de.bmwrudel.wds.gui.JStatusBar;
import de.bmwrudel.wds.gui.WDSJTree;
import de.bmwrudel.wds.localization.Messages;
import de.bmwrudel.wds.utils.WDSUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WDSSearchActionListener
implements ActionListener {
    private static final Logger _logger = LogManager.getLogger();
    private static String _searchString = null;
    private static List<TreePath> _resultSet = null;
    private static int _entryNumber = 0;
    private static WDSJTree _tree = null;
    private static WDSSearchResultDialog _dialog = new WDSSearchResultDialog();
    private JTextField textField;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (_tree == null) {
            this.initialize((Component)e.getSource());
        }
        String searchString = null;
        this.textField = null;
        if (e.getSource() instanceof JButton) {
            JButton btn = (JButton)e.getSource();
            JPanel panel = (JPanel)btn.getParent();
            this.textField = (JTextField)panel.getComponent(1);
        } else if (e.getSource() instanceof JTextField) {
            this.textField = (JTextField)e.getSource();
        }
        searchString = this.textField.getText();
        if (!searchString.equalsIgnoreCase(_searchString)) {
            _logger.debug("Search string: " + searchString);
            _searchString = searchString;
            _resultSet = _tree.findNodes(searchString);
            _logger.debug("Result count:  " + _resultSet.size());
            JStatusBar.setMessage(_resultSet.size() + Messages.getString("Search.resultCount"));
            _entryNumber = 0;
        }
        if (_entryNumber < _resultSet.size()) {
            TreePath treePath = _resultSet.get(_entryNumber);
            _tree.setSelectionPath(treePath);
            _tree.scrollPathToVisible(treePath);
            ++_entryNumber;
        } else {
            JOptionPane.showMessageDialog(null, Messages.getString("Search.noMoreResults"), Messages.getString("Search.noMoreResults"), 1);
            _entryNumber = 0;
        }
        if (_logger.isTraceEnabled()) {
            _dialog.addResultSets(_resultSet);
            _dialog.setVisible(true);
        }
    }

    private void initialize(Component object) {
        JFrame frame = (JFrame)SwingUtilities.getRoot(object);
        List<Component> allComponents = WDSUtils.getAllComponents(frame);
        for (Component comp : allComponents) {
            if (comp instanceof JSplitPane) {
                Component component = ((JSplitPane)comp).getLeftComponent();
            }
            if (!(comp instanceof WDSJTree)) continue;
            _tree = (WDSJTree)comp;
        }
    }
}

