/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.listeners;

import de.bmwrudel.wds.dialogs.WDSScematicExportDialog;
import de.bmwrudel.wds.fs.H2_FS;
import de.bmwrudel.wds.gui.WDSJTree;
import de.bmwrudel.wds.localization.Messages;
import de.bmwrudel.wds.navTree.WDSNavigationTreeNode;
import de.bmwrudel.wds.utils.WDSUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.apache.batik.swing.JSVGCanvas;

public class WDSSVGMouseListener
implements MouseMotionListener,
MouseListener {
    JSVGCanvas canvas = null;
    AffineTransform at = null;
    Point2D p1 = null;

    @Override
    public void mouseDragged(MouseEvent e) {
        AffineTransform at2 = (AffineTransform)this.at.clone();
        at2.translate(e.getX(), e.getY());
        at2.translate(-this.p1.getX(), -this.p1.getY());
        this.canvas.setRenderingTransform(at2, true);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.checkPopup(e);
        } else if (e.getSource() instanceof JSVGCanvas) {
            this.canvas = (JSVGCanvas)e.getSource();
            this.at = this.canvas.getRenderingTransform();
            this.p1 = e.getPoint();
            e.getComponent().setCursor(new Cursor(13));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            this.checkPopup(e);
        } else {
            e.getComponent().setCursor(new Cursor(0));
        }
    }

    private void checkPopup(MouseEvent ev) {
        JSVGCanvas canvas = (JSVGCanvas)ev.getSource();
        final String uri = canvas.getURI();
        JTabbedPane parent = (JTabbedPane)canvas.getParent().getParent();
        final String title = parent.getTitleAt(parent.getSelectedIndex());
        final Icon icon = parent.getIconAt(parent.getSelectedIndex());
        JPopupMenu pop = new JPopupMenu();
        pop.add(new AbstractAction(Messages.getString("ScematicExportDialog.title")){
            private static final long serialVersionUID = 6468131087245587689L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WDSScematicExportDialog dialog = new WDSScematicExportDialog();
                dialog.setName(title);
                dialog.setSourceUri(uri);
                dialog.setVisible(true);
            }
        });
        pop.add(new AbstractAction(Messages.getString("Bookmark.add")){
            private static final long serialVersionUID = 9022990447046897033L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu source2 = (JPopupMenu)((JMenuItem)e.getSource()).getParent();
                Component invoker = source2.getInvoker();
                Component root = SwingUtilities.getRoot(invoker);
                List<Component> allComponents = WDSUtils.getAllComponents((Container)root);
                JTree tree = null;
                for (Component comp : allComponents) {
                    if (!(comp instanceof WDSJTree)) continue;
                    tree = (WDSJTree)comp;
                }
                String selectionPath = null;
                for (Object path : tree.getSelectionPath().getPath()) {
                    WDSNavigationTreeNode node = (WDSNavigationTreeNode)path;
                    selectionPath = selectionPath == null ? node.getName() : selectionPath + "," + node.getName();
                }
                H2_FS.getInstance().add_bookmark(title, icon, selectionPath);
            }
        });
        pop.show(ev.getComponent(), ev.getX(), ev.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

