/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.listeners;

import de.bmwrudel.wds.fs.WdsFS;
import de.bmwrudel.wds.gui.JStatusBar;
import de.bmwrudel.wds.gui.WDSJTree;
import de.bmwrudel.wds.listeners.WDSBrowserMouseListener;
import de.bmwrudel.wds.listeners.WDSSVGMouseListener;
import de.bmwrudel.wds.listeners.WDSSVGMouseWheelListener;
import de.bmwrudel.wds.localization.Messages;
import de.bmwrudel.wds.navTree.WDSNavigationTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fit.cssbox.swingbox.BrowserPane;

public class WDSJTreeMouseListener
implements MouseListener {
    private static final Logger _logger = LogManager.getLogger();

    @Override
    public void mousePressed(MouseEvent e) {
        WDSJTree source = (WDSJTree)e.getSource();
        WDSNavigationTreeNode selected = (WDSNavigationTreeNode)source.getLastSelectedPathComponent();
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            this.processLeftDoubleClick(e, selected);
        } else if (e.isPopupTrigger()) {
            this.checkPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.checkPopup(e);
        }
    }

    private void processLeftDoubleClick(MouseEvent e, WDSNavigationTreeNode selected) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && selected.isLeaf()) {
            JFrame root = (JFrame)SwingUtilities.getRoot((WDSJTree)e.getSource());
            for (Component comp : root.getContentPane().getComponents()) {
                if (!(comp instanceof JSplitPane)) continue;
                JSplitPane split = (JSplitPane)comp;
                JTabbedPane tab = (JTabbedPane)split.getRightComponent();
                BrowserPane pane = null;
                String myText = "Image id: " + selected.getImageId() + " Link : " + selected.getLink() + ", is leaf: " + selected.isLeaf();
                String link = selected.getLink();
                String toolTip = selected.getName();
                String paneName = null;
                paneName = selected.getName().length() > 15 ? selected.getName().substring(0, 15) : selected.getName();
                switch (selected.getImageId()) {
                    case 11: {
                        link = link.replace("../svg/sp/", "").replace("htm", "svgz");
                        File svgFile = new File(WdsFS.getSVGLocation() + link);
                        JSVGCanvas canvas = new JSVGCanvas();
                        canvas.setDocumentState(3);
                        pane = new JSVGScrollPane(canvas);
                        ((JSVGScrollPane)pane).setScrollbarsAlwaysVisible(true);
                        WDSSVGMouseListener listener = new WDSSVGMouseListener();
                        canvas.addMouseWheelListener((MouseWheelListener)new WDSSVGMouseWheelListener());
                        canvas.addMouseMotionListener((MouseMotionListener)listener);
                        canvas.addMouseListener((MouseListener)listener);
                        canvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

                            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                                JStatusBar.setMessage(Messages.getString("SVGDocument.loading"));
                            }

                            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                                JStatusBar.setMessage(Messages.getString("SVGDocument.loaded"));
                            }
                        });
                        canvas.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

                            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                                JStatusBar.setMessage(Messages.getString("SVGDocument.build"));
                            }

                            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                                JStatusBar.setMessage(Messages.getString("SVGDocument.buildDone"));
                            }
                        });
                        canvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

                            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                                JStatusBar.setMessage(Messages.getString("SVGDocument.rendering"));
                            }

                            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                                JStatusBar.setMessage(Messages.getString("SVGDocument.rendered"));
                            }
                        });
                        tab.addTab(paneName, selected.getIcon(), (Component)pane);
                        canvas.setURI(svgFile.toURI().toString());
                        break;
                    }
                    case 13: 
                    case 15: 
                    case 17: 
                    case 19: 
                    case 21: 
                    case 23: 
                    case 25: 
                    case 27: {
                        pane = new BrowserPane();
                        pane.addMouseListener(new WDSBrowserMouseListener());
                        link.replace("../zinfo/", "");
                        File htmlFile = new File(WdsFS.getHTMLLocation() + link);
                        tab.addTab(paneName, selected.getIcon(), new JScrollPane((Component)pane, 20, 31));
                        tab.setToolTipTextAt(tab.getTabCount() - 1, toolTip);
                        tab.setSelectedIndex(tab.getTabCount() - 1);
                        try {
                            pane.setPage(htmlFile.toURI().toString());
                        }
                        catch (IOException e1) {
                            _logger.error("Error while loading html page", (Throwable)e1);
                        }
                        JStatusBar.setMessage("");
                        break;
                    }
                    default: {
                        _logger.error("DEFAULT case, text: " + myText);
                    }
                }
                tab.setToolTipTextAt(tab.getTabCount() - 1, toolTip);
                tab.setSelectedIndex(tab.getTabCount() - 1);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void checkPopup(MouseEvent ev) {
        JPopupMenu pop = new JPopupMenu();
        pop.add(new AbstractAction(Messages.getString("NavigationTree.collapseAll")){
            private static final long serialVersionUID = 6569259934117634456L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu source = (JPopupMenu)((JMenuItem)e.getSource()).getParent();
                WDSJTree invoker = (WDSJTree)source.getInvoker();
                invoker.collapseAll();
            }
        });
        pop.show(ev.getComponent(), ev.getX(), ev.getY());
    }
}

