/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.listeners;

import de.bmwrudel.wds.exporter.WDSDocumentExporter;
import de.bmwrudel.wds.fs.H2_FS;
import de.bmwrudel.wds.gui.WDSJTree;
import de.bmwrudel.wds.localization.Messages;
import de.bmwrudel.wds.navTree.WDSNavigationTreeNode;
import de.bmwrudel.wds.utils.WDSUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.fit.cssbox.swingbox.BrowserPane;

public class WDSBrowserMouseListener
implements MouseListener {
    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkPopup(e);
    }

    private void checkPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            final BrowserPane source = (BrowserPane)e.getSource();
            JTabbedPane parent = (JTabbedPane)source.getParent().getParent().getParent();
            final String title = parent.getTitleAt(parent.getSelectedIndex());
            final Icon icon = parent.getIconAt(parent.getSelectedIndex());
            JPopupMenu pop = new JPopupMenu();
            pop.add(new AbstractAction(Messages.getString("BrowserExportDialog.title")){
                private static final long serialVersionUID = -7387443438633027769L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    String srcFile = source.getPage().getFile();
                    JFileChooser chooseFile = new JFileChooser();
                    FileNameExtensionFilter filterPDF = new FileNameExtensionFilter(Messages.getString("ScematicExportDialog.pdfExtFilter.text"), "pdf", "PDF");
                    chooseFile.setFileFilter(filterPDF);
                    chooseFile.setSelectedFile(new File(FileSystemView.getFileSystemView().getDefaultDirectory().getPath() + File.separator + title.replace("/", "_") + ".pdf"));
                    if (chooseFile.showSaveDialog(null) == 0) {
                        WDSDocumentExporter.doExport(srcFile, chooseFile.getSelectedFile().toString());
                    }
                }
            });
            pop.add(new AbstractAction(Messages.getString("Bookmark.add")){
                private static final long serialVersionUID = -1657201174066899281L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPopupMenu source2 = (JPopupMenu)((JMenuItem)e.getSource()).getParent();
                    Component invoker = source2.getInvoker();
                    Component root = SwingUtilities.getRoot(invoker);
                    List<Component> allComponents = WDSUtils.getAllComponents((Container)root);
                    JTree tree = null;
                    for (Component comp : allComponents) {
                        if (!(comp instanceof WDSJTree)) continue;
                        tree = (WDSJTree)comp;
                    }
                    String selectionPath = null;
                    if (tree != null) {
                        for (Object path : tree.getSelectionPath().getPath()) {
                            WDSNavigationTreeNode node = (WDSNavigationTreeNode)path;
                            selectionPath = selectionPath == null ? node.getName() : selectionPath + "," + node.getName();
                        }
                    }
                    H2_FS.getInstance().add_bookmark(title, icon, selectionPath);
                }
            });
            pop.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

