/*
 * Decompiled with CFR 0.152.
 */
package de.bmwrudel.wds.gui;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.metal.MetalIconFactory;

public class JTabbedPaneCloseButton
extends JTabbedPane {
    private static final long serialVersionUID = -5383416074300354672L;

    public JTabbedPaneCloseButton() {
        this.setupTabTraversalKeys();
    }

    private void setupTabTraversalKeys() {
        KeyStroke ctrlTab = KeyStroke.getKeyStroke("ctrl TAB");
        KeyStroke ctrlShiftTab = KeyStroke.getKeyStroke("ctrl shift TAB");
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        forwardKeys.remove(ctrlTab);
        this.setFocusTraversalKeys(0, forwardKeys);
        HashSet<AWTKeyStroke> backwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(1));
        backwardKeys.remove(ctrlShiftTab);
        this.setFocusTraversalKeys(1, backwardKeys);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(ctrlTab, "navigateNext");
        inputMap.put(ctrlShiftTab, "navigatePrevious");
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        int count = this.getTabCount() - 1;
        this.setTabComponentAt(count, new CloseButtonTab(component, title, icon));
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        this.addTab(title, icon, component, null);
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, null, component);
    }

    public void addTabNoExit(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
    }

    public void addTabNoExit(String title, Icon icon, Component component) {
        this.addTabNoExit(title, icon, component, null);
    }

    public void addTabNoExit(String title, Component component) {
        this.addTabNoExit(title, null, component);
    }

    public class CloseListener
    implements MouseListener {
        private Component tab;

        public CloseListener(Component tab) {
            this.tab = tab;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() instanceof JButton) {
                JButton clickedButton = (JButton)e.getSource();
                JTabbedPane tabbedPane = (JTabbedPane)clickedButton.getParent().getParent().getParent();
                tabbedPane.remove(this.tab);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getSource() instanceof JButton) {
                JButton jButton = (JButton)e.getSource();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getSource() instanceof JButton) {
                JButton jButton = (JButton)e.getSource();
            }
        }
    }

    public class CloseButtonTab
    extends JPanel {
        private static final long serialVersionUID = 4474882822631689165L;
        private Component tab;

        public CloseButtonTab(Component tab, String title, Icon icon) {
            this.tab = tab;
            this.setOpaque(false);
            FlowLayout flowLayout = new FlowLayout(1, 3, 3);
            this.setLayout(flowLayout);
            JLabel jLabel = new JLabel(title);
            jLabel.setIcon(icon);
            this.add(jLabel);
            JButton button = new JButton(MetalIconFactory.getInternalFrameCloseIcon(8));
            button.setMargin(new Insets(0, 0, 0, 0));
            button.addMouseListener(new CloseListener(tab));
            this.add(button);
        }
    }
}

